% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xz.R
\name{xzcompress}
\alias{xzcompress}
\alias{xzuncompress}
\title{Compressing and uncompressing text files}
\usage{
xzcompress(filename, destname = sprintf("\%s.xz", filename),
  temporary = FALSE, skip = FALSE, overwrite = FALSE, remove = TRUE,
  BFR.SIZE = 1e+07, compression = 6, ...)

xzuncompress(filename, destname = gsub("[.]xz$", "", filename, ignore.case =
  TRUE), temporary = FALSE, skip = FALSE, overwrite = FALSE,
  remove = TRUE, BFR.SIZE = 1e+07, ...)
}
\arguments{
\item{filename}{Path name of input file.}

\item{destname}{Pathname of output file.}

\item{temporary}{If TRUE, the output file is created in a temporary directory.}

\item{skip}{If TRUE and the output file already exists, the output file is returned as is.}

\item{overwrite}{If TRUE and the output file already exists, the file is silently overwritting,
otherwise an exception is thrown (unless skip is TRUE).}

\item{remove}{If TRUE, the input file is removed afterward, otherwise not.}

\item{BFR.SIZE}{The number of bytes read in each chunk.}

\item{compression}{The compression level used (1-9).}

\item{...}{Not used.}
}
\value{
Returns the pathname of the output file. The number of bytes processed is returned as an attribute.
}
\description{
These functions are adapted from the \code{R.utils} package from gzip to xz. Internally
\code{xzfile()} (see connections) is used to read (write) chunks to (from) the xz file. If the
process is interrupted before completed, the partially written output file is automatically removed.
}
\examples{
# Creating small file
tf <- tempfile()
cat(file=tf, "Hello world!")

# Compressing
tf.xz <- xzcompress(tf)
print(file.info(tf.xz))

# Uncompressing
tf <- xzuncompress(tf.xz)
print(file.info(tf))
file.remove(tf)

}
\author{
Kristian Hovde Liland.
}
