% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivldv.R
\name{ivldv}
\alias{ivldv}
\alias{endogtest}
\alias{endogtest.formula}
\alias{endogtest.ivldv}
\title{Instrumental variable estimators for limited dependent variable}
\usage{
ivldv(
  formula,
  data,
  subset = NULL,
  weights = NULL,
  na.action,
  offset,
  method = c("twosteps", "minchisq", "ml", "test"),
  model = c("probit", "tobit"),
  robust = TRUE,
  left = 0,
  right = Inf,
  trace = 0,
  ...
)

endogtest(x, ...)

\method{endogtest}{formula}(x, ..., data, model = c("probit", "tobit"))

\method{endogtest}{ivldv}(x, ...)
}
\arguments{
\item{formula}{a symbolic description of the model,}

\item{data}{a data frame,}

\item{subset, weights, na.action, offset}{see \code{lm},}

\item{method}{one of \code{"ml"} for maximum likelihood, "twosteps"\code{and}"minchisq"`}

\item{model}{one of \code{"probit"} or \code{"tobit"},}

\item{robust}{a boolean, if \code{TRUE}, a consistent estimation of the
covariance of the coefficients is used for the 2-steps method,}

\item{left, right}{left and right limits of the dependent
variable. The default is respectively 0 and +Inf which
corresponds to the most classic (left-zero truncated) tobit
model,}

\item{trace}{a boolean (the default if \code{FALSE}) if \code{TRUE} some
information about the optimization process is printed,}

\item{...}{further arguments}

\item{x}{on object returned by \code{ivldv}}
}
\value{
An object of class \code{c('ivldv', 'lm')}
}
\description{
Estimation of simultaneous-equation models when the response is
binomial or censored
}
\examples{
inst <- ~ sic3 + k_serv + inv + engsci + whitecol + skill + semskill + cropland + 
    pasture + forest + coal + petro + minerals + scrconc + bcrconc + scrcomp +
    bcrcomp + meps + kstock + puni + geog2 + tenure + klratio + bunion
trade_protection <- dplyr::mutate(micsr::trade_protection,
                                 y = ntb / (1 + ntb),
                                 x1 = vshipped / imports / elast,
                                 x2 = cap * x1,
                                 x3 = labvar)
GH <- ivldv(Formula::as.Formula(y  ~  x1 + x2, inst), trade_protection,
            method = "twosteps", model = "tobit") 
Full <- ivldv(Formula::as.Formula(y ~ x1 + x2 + labvar, inst), trade_protection,
              method = "twosteps", model = "tobit") 
Short <- ivldv(Formula::as.Formula(y ~ x1 + I(x2 + labvar), inst),
                 trade_protection, method = "twosteps", model = "tobit")
bank_msq <- ivldv(federiv ~ eqrat + optval + bonus + ltass + linsown + linstown +
                  roe + mktbk + perfor + dealdum + div + year | . - eqrat - bonus -
                  optval + no_emp + no_subs + no_off + ceo_age + gap + cfa,
                  data = federiv, method = "minchisq")
bank_ml <- update(bank_msq, method = "ml")
bank_2st <- update(bank_msq, method = "twosteps")
}
\references{
\insertRef{SMIT:BLUN:86}{micsr}

\insertRef{RIVE:VUON:88}{micsr}
}
\author{
Yves Croissant
}
\keyword{models}
