% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numeric_encoder.R
\name{numeric.encoder}
\alias{numeric.encoder}
\alias{numeric.frame}
\alias{print.encoder}
\title{Encoder for Quantitative Variables}
\usage{
numeric.encoder(
  x,
  k,
  type = 1L,
  encoding.digits = NULL,
  tag = "x",
  frame = NULL,
  weights = NULL
)

numeric.frame(
  reps = NULL,
  breaks = NULL,
  type = NULL,
  encoding.digits = NULL,
  tag = "x"
)

\method{print}{encoder}(x, digits = NULL, ...)
}
\arguments{
\item{x}{a numeric vector to be encoded.}

\item{k}{an integer specifying the coarseness of the encoding. If not positive, all unique values of x are used as sample points.}

\item{type}{an integer specifying the encoding method. If \code{1}, values are encoded to a \code{[0, 1]} scale based on linear interpolation of the knots. If \code{0}, values are encoded to \code{0} or \code{1} using ont-hot encoding on the intervals.}

\item{encoding.digits}{an integer specifying the rounding digits for the encoding in case \code{type} is \code{1}.}

\item{tag}{character string. The name of the variable.}

\item{frame}{a "numeric.frame" object or a numeric vector that defines the sample points of the binning.}

\item{weights}{optional. A numeric vector of sample weights for each value of \code{x}.}

\item{reps}{a numeric vector to be used as the representative values (knots).}

\item{breaks}{a numeric vector to be used as the binning breaks.}

\item{digits}{the minimum number of significant digits to be used.}

\item{...}{not used.}
}
\value{
\code{numeric.encoder()} returns a list containing the following components:
\item{frame}{an object of class "numeric.frame".}
\item{encode}{a function to encode \code{x} into a dummy matrix.}
\item{n}{the number of encoding levels.}
\item{type}{the type of encoding, "linear" or "constant".}
\code{numeric.frame()} returns a "numeric.frame" object containing the encoding information.
}
\description{
\code{numeric.encoder()} returns an encoder for a quantitative variable.
}
\details{
\code{numeric.encoder()} selects sample points from the variable \code{x} and returns a list containing the \code{encode()} function to convert a vector into a dummy matrix.
If \code{type} is \code{1}, \code{k} is considered the maximum number of knots, and the values between two knots are encoded as two decimals, reflecting the relative position to the knots.
If \code{type} is \code{0}, \code{k} is considered the maximum number of intervals, and the values are converted using one-hot encoding on the intervals.
}
\examples{
data(iris, package = "datasets")
enc <- numeric.encoder(x = iris$Sepal.Length, k = 5L, tag = "Sepal.Length")
enc$frame
enc$encode(x = c(4:8, NA))

frm <- numeric.frame(breaks = seq(3, 9, 2), type = 0L)
enc <- numeric.encoder(x = iris$Sepal.Length, frame = frm)
enc$encode(x = c(4:8, NA))

enc <- numeric.encoder(x = iris$Sepal.Length, frame = seq(3, 9, 2))
enc$encode(x = c(4:8, NA))
}
