% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipf3_diag.R
\name{ipf3_diag}
\alias{ipf3_diag}
\title{Iterative Proportional Fitting Routine for the Indirect Estimation of Origin-Destination-Migrant Type Migration Flow Tables with Known Origin and Destination Margins and Diagonal Elements.}
\usage{
ipf3_diag(rtot = NULL, ctot = NULL, dtot = NULL, m = NULL,
  speed = TRUE, tol = 1e-05, maxit = 500, verbose = TRUE)
}
\arguments{
\item{rtot}{Vector of origin totals to constrain the sum of the imputed cell rows.}

\item{ctot}{Vector of destination totals to constrain the sum of the imputed cell columns.}

\item{dtot}{Array with counts on diagonal to constrain diagonal elements of the indirect estimates too. By default these are taken as their maximum possible values given the relevant margins totals in each table. If user specifies their own array of diagonal totals, values on the non-diagonals in the array can take any positive number (they are ultimately ignored).}

\item{m}{Array of auxiliary data. By default set to 1 for all origin-destination-migrant typologies combinations.}

\item{speed}{Speeds up the IPF algorithm by minimizing sufficient statistics.}

\item{tol}{Numeric value for the tolerance level used in the parameter estimation.}

\item{maxit}{Numeric value for the maximum number of iterations used in the parameter estimation.}

\item{verbose}{Logical value to indicate the print the parameter estimates at each iteration. By default \code{FALSE}.}
}
\value{
Iterative Proportional Fitting routine set up using the partial likelihood derivatives illustrated in Abel (2013). The arguments \code{rtot} and \code{ctot} take the row-table and column-table specific known margins. By default the diagonal values are taken as their maximum possible values given the relevant margins totals in each table. Diagonal values can be added by the user, but care must be taken to ensure resulting diagonals are feasible given the set of margins. 

The user must ensure that the row and column totals in each table sum to the same value. Care must also be taken to allow the dimension of the auxiliary matrix (\code{m}) equal those provided in the row and column totals.

Returns a \code{list} object with
\item{mu }{Array of indirect estimates of origin-destination matrices by migrant characteristic}
\item{it }{Iteration count}
\item{tol }{Tolerance level at final iteration}
}
\description{
This function is predominantly intended to be used within the \code{\link{ffs}} routine.
}
\details{
The \code{ipf3} function finds the maximum likelihood estimates for fitted values in the log-linear model:
\deqn{ \log y_{ijk} = \log \alpha_{i} + \log \beta_{j} + \log \lambda_{k} + \log \gamma_{ik} + \log \kappa_{jk} + \log \delta_{ijk}I(i=j) + \log m_{ijk} }
where \eqn{m_{ijk}} is a set of prior estimates for \eqn{y_{ijk}} and is no more complex than the matrices being fitted. The \eqn{\delta_{ijk}I(i=j)} term ensures a saturated fit on the diagonal elements of each \eqn{(i,j)} matrix.
}
\examples{
## create row-table and column-table specific known margins.
dn <- LETTERS[1:4]
P1 <- matrix(c(1000, 100,  10,   0, 
               55,   555,  50,   5, 
               80,    40, 800 , 40, 
               20,    25,  20, 200), 
             nrow = 4, ncol = 4, byrow = TRUE, 
             dimnames = list(pob = dn, por = dn))
P2 <- matrix(c(950, 100,  60,   0, 
                80, 505,  75,   5, 
                90,  30, 800,  40, 
                40,  45,   0, 180), 
             nrow = 4, ncol = 4, byrow = TRUE, 
             dimnames = list(pob = dn, por = dn))
# display with row and col totals
addmargins(P1)
addmargins(P2)

# run ipf

## with alternative offset term
dis <- array(c(1, 2, 3, 4, 2, 1, 5, 6, 3, 4, 1, 7, 4, 6, 7, 1), c(4, 4, 4))
y <- ipf3_diag(rtot = t(P1), ctot = P2, m = dis)
# display with row, col and table totals
round(addmargins(y$mu), 1)
# origin-destination flow table
round(od_sum(y$mu), 1) 
}
\references{
Abel, G. J. (2013). Estimating Global Migration Flow Tables Using Place of Birth. \emph{Demographic Research} 28, (18) 505-546
}
\seealso{
\code{\link{ipf3}}, \code{\link{ffs}}, \code{\link{od_sum}}
}
\author{
Guy J. Abel
}
