% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm2.R
\name{cm2}
\alias{cm2}
\title{Conditional maximization routine for the indirect estimation of origin-destination migration flow table with known margins}
\usage{
cm2(
  row_tot = NULL,
  col_tot = NULL,
  m = matrix(data = 1, nrow = length(row_tot), ncol = length(col_tot)),
  tol = 1e-06,
  maxit = 500,
  verbose = TRUE,
  rtot = row_tot,
  ctot = col_tot
)
}
\arguments{
\item{row_tot}{Vector of origin totals to constrain the sum of the imputed cell rows.}

\item{col_tot}{Vector of destination totals to constrain the sum of the imputed cell columns.}

\item{m}{Matrix of auxiliary data. By default set to 1 for all origin-destination combinations.}

\item{tol}{Numeric value for the tolerance level used in the parameter estimation.}

\item{maxit}{Numeric value for the maximum number of iterations used in the parameter estimation.}

\item{verbose}{Logical value to indicate the print the parameter estimates at each iteration. By default \code{FALSE}.}

\item{rtot}{Depreciated. Use \code{row_tot}}

\item{ctot}{Depreciated. Use \code{col_tot}}
}
\value{
Parameter estimates are obtained using the EM algorithm outlined in Willekens (1999). This is equivalent to a conditional maximization of the likelihood, as discussed by Raymer et. al. (2007). It also provides identical indirect estimates to those obtained from the \code{\link{ipf2}} routine. 

The user must ensure that the row and column totals are equal in sum. Care must also be taken to allow the dimension of the auxiliary matrix (\code{m}) to equal those provided in the row (\code{row_tot}) and column (\code{col_tot}) arguments.

Returns a \code{list} object with
\item{N }{Origin-Destination matrix of indirect estimates}
\item{theta }{Collection of parameter estimates}
}
\description{
The \code{cm2} function finds the maximum likelihood estimates for parameters in the log-linear model:
\deqn{ \log y_{ij} = \log \alpha_i + \log \beta_j + \log m_{ij} }
as introduced by Willekens (1999). The \eqn{\alpha_i} and  \eqn{\beta_j} represent background information related to  the characteristics of the origin and destinations respectively. The \eqn{m_{ij}} factor represents auxiliary information on migration flows, which imposes its interaction structure onto the estimated flow matrix.
}
\examples{
## with Willekens (1999) data
dn <- LETTERS[1:2]
y <- cm2(row_tot = c(18, 20), col_tot = c(16, 22), 
         m = matrix(c(5, 1, 2, 7), ncol = 2, dimnames = list(orig = dn, dest = dn)))
y

## with all elements of offset equal (independence fit)
y <- cm2(row_tot = c(18, 20), col_tot = c(16, 22))
y

## with bigger matrix
dn <- LETTERS[1:4]
y <- cm2(row_tot = c(250, 100, 140, 110), col_tot = c(150, 150, 180, 120),
         m = matrix(data = c(0, 100, 30, 70, 50, 0, 45, 5, 60, 35, 0, 40, 20, 25, 20, 0),
                    nrow = 4, ncol = 4, dimnames = list(orig = dn, dest = dn), byrow = TRUE))
                    
# display with row and col totals
round(addmargins(y$n)) 
}
\references{
Raymer, J., G. J. Abel, and P. W. F. Smith (2007). Combining census and registration data to estimate detailed elderly migration flows in England and Wales. \emph{Journal of the Royal Statistical Society: Series A (Statistics in Society)} 170 (4), 891--908.

Willekens, F. (1999). Modelling Approaches to the Indirect Estimation of Migration Flows: From Entropy to EM. \emph{Mathematical Population Studies} 7 (3), 239--78.
}
\seealso{
\code{\link{ipf2}}
}
\author{
Guy J. Abel
}
