% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_intensity.R
\name{index_intensity}
\alias{index_intensity}
\title{Summary indices of migration intensity}
\source{
Bell, M., Blake, M., Boyle, P., Duke-Williams, O., Rees, P. H., Stillwell, J., & Hugo, G. J. (2002). Cross-national comparison of internal migration: issues and measures. Journal of the Royal Statistical Society: Series A (Statistics in Society), 165(3), 435–464. https://doi.org/10.1111/1467-985X.00247

Courgeau, D. (1973). Migrants et migrations. Population, 28(1), 95–129. https://doi.org/10.2307/1530972

Bernard, A., Rowe, F., Bell, M., Ueffing, P., Charles-Edwards, E., & Zhu, Y. (2017). Comparing internal migration across the countries of Latin America: A multidimensional approach. Plos One, 12(3), e0173895. https://doi.org/10.1371/journal.pone.0173895
}
\usage{
index_intensity(mig_total = NULL, pop_total = NULL, n = NULL, long = TRUE)
}
\arguments{
\item{mig_total}{Numeric value for the total number of migrations.}

\item{pop_total}{Numeric value for the total population.}

\item{n}{Numeric value for the number of regions used in the definition of migration for \code{mig_total}.}

\item{long}{Logical to return a long data frame with index values all in one column}
}
\value{
A tibble with 2 summary measures where
\item{cmp}{Crude migration probability from Bell et. al. (2002), sometimes known as crude migration intensity, e.g. Bernard (2017)}
\item{courgeau_k}{Intensity measure of Courgeau (1973)}
}
\description{
Summary indices of migration intensity
}
\examples{
# single year
library(dplyr)
m <- korea_reg \%>\%
  filter(year == 2020,
         orig != dest) \%>\%
  pull(flow) \%>\%
  sum()
m
p <- korea_pop \%>\%
  filter(year == 2020) \%>\%
  pull(population) \%>\%
  sum()
p
index_intensity(mig_total = m, pop_total = p, n = n_distinct(korea_pop$region))

# multiple years
mm <- korea_reg \%>\%
  group_by(year) \%>\%
  filter(orig != dest) \%>\%
  summarise(m = sum(flow))
mm
pp <- korea_pop \%>\%
  group_by(year) \%>\%
  summarise(p = sum(population))
pp

library(purrr)
library(tidyr)
mm \%>\%
  left_join(pp) \%>\%
  mutate(i = map2(.x = m, .y = p,
                  .f = ~index_intensity(mig_total = .x,
                                        pop_total = .y,
                                        n = n_distinct(korea_pop$region),
                                        long = FALSE))) \%>\%
  unnest(cols = i)
}
