% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_net.R
\name{sum_net}
\alias{sum_net}
\title{Calculate net migration from an origin-destination migration flow matrix.}
\usage{
sum_net(m, region = 1:dim(m)[1])
}
\arguments{
\item{m}{Matrix of origin-destination flows, where the first and second dimensions correspond to origin and destination respectively.}

\item{region}{Integer value corresponding to the region that the net migration sum is desired. Will return sums for all regions by default.}
}
\value{
Returns a numeric value of the sum of a single block.
}
\description{
Sums each regions flows to obtain net migration sums.
}
\examples{
r <- LETTERS[1:4]
m <- matrix(data = 1:16, nrow = 4, ncol = 4,
            dimnames = list(orig = r, dest = r))
m
sum_net(m)
}
\author{
Guy J. Abel
}
