% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_age_rc.R
\name{index_age_rc}
\alias{index_age_rc}
\title{Summary indices of age migration profile based on parameters from a Rogers and Castro schedule}
\source{
Rogers, A., & Castro, L. J. (1981). Model Migration Schedules. In IIASA Research Report (Vol. 81, Issue RR-81-30). http://webarchive.iiasa.ac.at/Admin/PUB/Documents/RR-81-030.pdf
}
\usage{
index_age_rc(pars = NULL, long = TRUE)
}
\arguments{
\item{pars}{Named vector or parameters parameters from a Rogers and Castro schedule}

\item{long}{Logical to return a long data frame with index values all in one column}
}
\value{
A tibble with at least five summary measures
}
\description{
Summary indices of age migration profile based on parameters from a Rogers and Castro schedule
}
\examples{
library(dplyr)
library(tibble)
rc_model_fund \%>\%
  deframe() \%>\%
  index_age_rc()
}
