% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_features.R
\name{features}
\alias{features}
\alias{network_core}
\alias{network_factions}
\alias{network_modularity}
\alias{network_smallworld}
\alias{network_balance}
\title{Measures of network topological features}
\source{
\code{{signnet}} by David Schoch
}
\usage{
network_core(object, membership = NULL)

network_factions(object, membership = NULL)

network_modularity(object, membership = NULL, resolution = 1)

network_smallworld(object, times = 100)

network_balance(object)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{membership}{A vector of partition membership.}

\item{resolution}{A proportion indicating the resolution scale.
By default 1.}

\item{times}{Integer of number of simulations.}
}
\description{
Measures of network topological features
}
\section{Functions}{
\itemize{
\item \code{network_core()}: Returns correlation between a given network
and a core-periphery model with the same dimensions.

\item \code{network_factions()}: Returns correlation between a given network
and a component model with the same dimensions.

\item \code{network_modularity()}: Returns modularity of one- or two-mode networks
based on nodes' membership in pre-defined clusters.

\item \code{network_smallworld()}: Returns small-world metrics for one- and
two-mode networks.
Small-world networks can be highly clustered and yet
have short path lengths.

\item \code{network_balance()}: Returns the structural balance index on
the proportion of balanced triangles,
ranging between \code{0} if all triangles are imbalanced and
\code{1} if all triangles are balanced.

}}
\examples{
network_core(ison_adolescents)
network_core(ison_southern_women)
network_factions(ison_adolescents)
network_factions(ison_southern_women)
network_modularity(ison_adolescents, 
  node_kernighanlin(ison_adolescents))
network_modularity(ison_southern_women, 
  node_kernighanlin(ison_southern_women))
network_smallworld(ison_brandes)
network_smallworld(ison_southern_women)
network_balance(ison_marvel_relationships)
}
\references{
Borgatti, Stephen P., and Martin G. Everett. 2000.
“Models of Core/Periphery Structures.”
\emph{Social Networks} 21(4):375–95.
\doi{10.1016/S0378-8733(99)00019-2}

Murata, Tsuyoshi. 2010. Modularity for Bipartite Networks.
In: Memon, N., Xu, J., Hicks, D., Chen, H. (eds)
\emph{Data Mining for Social Network Data. Annals of Information Systems}, V1ol 12.
Springer, Boston, MA.
\doi{10.1007/978-1-4419-6287-4_7}

Watts, Duncan J., and Steven H. Strogatz. 1998.
“Collective Dynamics of ‘Small-World’ Networks.”
\emph{Nature} 393(6684):440–42.
\doi{10.1038/30918}.
}
\seealso{
\code{\link[=network_transitivity]{network_transitivity()}} and \code{\link[=network_equivalency]{network_equivalency()}}
for how clustering is calculated

Other measures: 
\code{\link{centralisation}},
\code{\link{centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{diversity}},
\code{\link{holes}}
}
\concept{measures}
