% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migrate.R
\name{migrate}
\alias{migrate}
\title{Summarize the migration of a data frame}
\usage{
migrate(
  data,
  id,
  time,
  state,
  metric = NULL,
  percent = TRUE,
  fill_state = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{A data frame or data frame extension (e.g., a tibble or
data.table) containing a minimum of three (3) column variables representing
a time, a credit risk state, and an ID identifying the credit facility (we
would expect to see most unique values in this column variable appear twice
in the dataset; once at the first unique \code{time} value and again at the
second unique \code{time} value, unless the ID only existed at one of those two
times).}

\item{id}{The column variable of the \code{data} data frame argument that contains
the unique identifier to track where a particular credit facility migrated
to/from. If left null, \code{migrate()} will attempt to use the first column
variable from the data frame provided in the \code{data} argument.}

\item{time}{The column variable of in the \code{data} data frame representing the
timepoint (e.g., a Date) of each observation; this column should contain
two unique values (migration from Time A to Time B)}

\item{state}{The column variable of the \code{data} data frame argument that
contains the credit risk state values.}

\item{metric}{(Optional) The column variable of type "numeric" in the \code{data}
data frame argument that contains the continuous metric values to weight
the state migration by}

\item{percent}{If \code{FALSE}, will calculate the migration on an absolute basis
(rather than a percentage basis, which is the default)}

\item{fill_state}{(Optional) A value (e.g., a character string such as "No
Rating" or "NR") to be used as the \emph{filler} \code{state} for any \code{id} values
that only exist at one timepoint in the \code{data}.}

\item{verbose}{If \code{TRUE}, the function returns an informational message about
the transition period}
}
\value{
A data frame containing three (3) column variables representing the unique
combinations of starting & ending credit risk states and the calculated
migration observed during the period.
}
\description{
\code{migrate()} summarizes the transition amount (or percentage) of a numeric
variable from each beginning credit risk state category to each ending credit
risk state, given a data frame input.
}
\examples{
# Return the percent migration of the number of credit facilities
migrate(
  data = mock_credit,
  id = customer_id,
  time = date,
  state = risk_rating
)

# Return the absolute migration in `principal_balance`
migrate(
  data = mock_credit,
  id = customer_id,
  time = date,
  state = risk_rating,
  metric = principal_balance,
  percent = FALSE
)

# Provide a filler `state` value when a unique `id` is missing a timepoint
migrate(
  data = head(mock_credit, n = 995),   # drop the last 5 observations
  id = customer_id,
  time = date,
  state = risk_rating,
  fill_state = "NR",
  percent = FALSE
)
}
