% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_importance.R
\name{lower_bound}
\alias{lower_bound}
\alias{upper_bound}
\alias{bounds}
\title{Get the lower and upper bounds for an empirical confidence interval}
\usage{
lower_bound(x, alpha)

upper_bound(x, alpha)
}
\arguments{
\item{x}{vector of test statistics, such as from permutation tests or bootstraps}

\item{alpha}{alpha level for the confidence interval
(default: \code{0.05} to obtain a 95\% confidence interval)}
}
\value{
the value of the lower or upper bound for the confidence interval
}
\description{
Get the lower and upper bounds for an empirical confidence interval
}
\section{Functions}{
\itemize{
\item \code{lower_bound()}: Get the lower bound for an empirical confidence interval

\item \code{upper_bound()}: Get the upper bound for an empirical confidence interval

}}
\examples{
\dontrun{
x <- 1:10000
lower_bound(x, 0.05)
upper_bound(x, 0.05)
}
}
\keyword{internal}
