% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_val.R
\name{keep_groups_in_cv_partitions}
\alias{keep_groups_in_cv_partitions}
\title{Whether groups can be kept together in partitions during cross-validation}
\usage{
keep_groups_in_cv_partitions(groups, group_partitions, kfold)
}
\arguments{
\item{groups}{Vector of groups to keep together when splitting the data into
train and test sets. If the number of groups in the training set is larger
than \code{kfold}, the groups will also be kept together for cross-validation.
Length matches the number of rows in the dataset (default: \code{NULL}).}

\item{group_partitions}{Specify how to assign \code{groups} to the training and
testing partitions (default: \code{NULL}). If \code{groups} specifies that some
samples belong to group \code{"A"} and some belong to group \code{"B"}, then setting
\code{group_partitions = list(train = c("A", "B"), test = c("B"))} will result
in all samples from group \code{"A"} being placed in the training set, some
samples from \code{"B"} also in the training set, and the remaining samples from
\code{"B"} in the testing set. The partition sizes will be as close to
\code{training_frac} as possible. If the number of groups in the training set is
larger than \code{kfold}, the groups will also be kept together for
cross-validation.}

\item{kfold}{Fold number for k-fold cross-validation (default: \code{5}).}
}
\value{
\code{TRUE} if possible, \code{FALSE} otherwise
}
\description{
Whether groups can be kept together in partitions during cross-validation
}
\author{
Kelly Sovacool, \email{sovacool@umich.edu}
}
\keyword{internal}
