% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{randomize_feature_order}
\alias{randomize_feature_order}
\title{Randomize feature order to eliminate any position-dependent effects}
\usage{
randomize_feature_order(dataset, outcome_colname)
}
\arguments{
\item{dataset}{Data frame with an outcome variable and other columns as features.}

\item{outcome_colname}{Column name as a string of the outcome variable
(default \code{NULL}; the first column will be chosen automatically).}
}
\value{
Dataset with feature order randomized.
}
\description{
Randomize feature order to eliminate any position-dependent effects
}
\examples{
dat <- data.frame(
  outcome = c("1", "2", "3"),
  a = 4:6, b = 7:9, c = 10:12, d = 13:15
)
randomize_feature_order(dat, "outcome")
}
\author{
Nick Lesniak, \email{nlesniak@umich.edu}

Kelly Sovacool, \email{sovacool@umich.edu}
}
