/*
 * Decompiled with CFR 0.152.
 */
package analysis.results;

import analysis.results.Result;
import data.VarPairData;
import java.io.IOException;
import mine.core.MineParameters;

public class MinimalResult
extends Result {
    protected float MIC = Float.NaN;

    @Override
    public void construct(VarPairData xy, MineParameters p) {
        super.construct(xy, p);
        this.MIC = this.m.MIC();
        if (p.debug > 1) {
            try {
                p.debugOut.write("MIC (=" + this.getMIC() + ")\n");
                p.debugOut.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean worthMentioning() {
        return this.MIC > 1.0E-6f;
    }

    @Override
    public String getHeader() {
        String header = "X var,Y var,MIC (strength)";
        return header;
    }

    @Override
    public float getMainScore() {
        return this.getMIC();
    }

    @Override
    public String toString() {
        String result = String.valueOf(this.getXVar()) + "," + this.getYVar() + "," + this.MIC;
        result = result.replace(Float.toString(Float.NaN), "");
        result = result.replace(Integer.toString(Integer.MIN_VALUE), "");
        result = result.replace(Integer.toString(Integer.MAX_VALUE), "ERROR");
        return result;
    }

    public float getMIC() {
        return this.MIC;
    }
}

