% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mini-document.R
\name{mini_document}
\alias{mini_document}
\title{Convert to an HTML document powered by the lightweight CSS framework.}
\usage{
mini_document(
  framework = "sakura",
  theme = "default",
  toc = FALSE,
  toc_float = FALSE,
  toc_highlight = FALSE,
  section_divs = TRUE,
  code_folding = c("none", "show", "hide"),
  results_folding = c("none", "show", "hide"),
  tabset = FALSE,
  code_download = FALSE,
  self_contained = TRUE,
  math = "katex",
  template = "default",
  extra_dependencies = NULL,
  includes = list(),
  keep_md = FALSE,
  pandoc_args = NULL,
  ...
)
}
\arguments{
\item{framework, theme}{A string to specify the name of a framework
(default: \code{"sakura"}) and its theme (default: \code{"default"}).
Note that \code{theme = "default"} is a special keyword which selects a theme
defined as default internally. See \code{frameworks} for available light weight
CSS frameworks and their themes. If you want to scratch styles by yourself,
use \code{framework = "none"}.}

\item{toc}{\code{TRUE} to include a table of contents in the output}

\item{toc_float}{TRUE to float the table of contents to the left of the main
document content.}

\item{toc_highlight}{This is an experimental feature. \code{TRUE} highlights the
table of contents according to the browser's viewport.}

\item{section_divs}{Wrap sections in \code{<div>} tags, and attach identifiers to the
enclosing \code{<div>} rather than the header itself.}

\item{code_folding}{Setup code folding by a string or a named list.
A choice for the string are \code{"none"} to disable,
\code{"show"} to enable and show all by default), and
\code{"hide"} to enable and hide all by default.
If a named list, each element may have one of the above strings.
Names are some of "source", "output", "message", "warning", and "error".
If the list does not have some of the element with the above name,
they are treated as \code{"none"}.}

\item{results_folding}{Setup results folding by a string, \code{"none"}, \code{"show"},
or \code{"hide"}. This feature will fold entire results, including side effects
such as figures and tables.}

\item{tabset}{\code{TRUE} converts sections to tabs if they belong to the
\code{tabset}-class section. The tabs inherit names from the corresponding
sections. Unlike \code{rmarkdown::html_document}, the tabs can be navigated by
table of contents, and can be shared by unique URLs. Note that
\code{framework = "bootstrap"} falls back to the native feature of
\code{rmarkdown::html_document}. This feature also requires \code{section_divs = TRUE}.}

\item{code_download}{If \code{TRUE} and \code{framework = "bootstrap"}, the output
includes Rmd file itself and supplies download button of it.}

\item{self_contained}{Produce a standalone HTML file with no external
dependencies, using data: URIs to incorporate the contents of linked
scripts, stylesheets, images, and videos. Note that even for self contained
documents MathJax is still loaded externally (this is necessary because of
its size).}

\item{math}{A string to specify math rendering engine (default: \code{"katex"}).
If the value is other than \code{"katex"}, the result depends on the \code{framework}
option. When the given \code{framework} is \code{"bootstrap"}, the \code{math} option is
passed to the \code{mathjax} option of \code{rmarkdown::html_document}. Otherwise,
pandoc's built-in feature renders math expressions to unicode characters.}

\item{template}{Pandoc template. If "default", the package's internal template
is used. If a path, user's original template is used. If \code{NULL}, pandoc's
internal template is used.}

\item{extra_dependencies}{Additional function arguments to pass to the
base R Markdown HTML output formatter \code{\link[rmarkdown]{html_document_base}}}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link[rmarkdown]{includes}} function).}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{...}{Arguments passed to \code{rmarkdown::html_document}}
}
\description{
The output format is HTML5 in general. If \code{framework = "bootstrap"} is given,
the output format becomes HTML4 and comparable to \code{rmarkdown::html_document}
except for the behavior of the \code{code_folding} option.
}
\examples{
\dontrun{
library(rmarkdown)
library(minidown)
render("input.Rmd", mini_document)
}
}
