% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{daemons}
\alias{daemons}
\title{daemons (Background and Remote Processes)}
\usage{
daemons(n, .url)
}
\arguments{
\item{n}{integer number of daemons to set | 'view' to view the current number
of daemons.}

\item{.url}{(optional) for distributing tasks across the network: character
client URL and port accepting incoming connections e.g.
'tcp://192.168.0.2:5555' at which server processes started using
\code{\link{server}} should connect to. To listen to port 5555 (for example)
on all interfaces on the host, specify one of 'tcp://:5555',
'tcp://*:5555' or 'tcp://0.0.0.0:5555'.}
}
\value{
Depending on 'n' specified:
    \itemize{
    \item{integer: integer change in number of daemons (created or destroyed).}
    \item{'view': integer number of currently set daemons.}
    }
}
\description{
Set or view the number of daemons (server processes). Create persistent
    background processes to receive \code{\link{mirai}} requests, providing
    an efficient solution for async operations on a local machine. Also
    provides the interface for distributing requests across the network.
}
\details{
Set 'n' to 0 to reset all daemon connections. \{mirai\} will revert
    to the default behaviour of creating a new background process for each
    request.

    Specifying a custom client URL without 'n' (or 'n' < 1) will default to a
    value for 'n' of 1.

    Calling \code{daemons()} without any arguments returns the 'nanoSocket'
    for connecting to the daemons, or NULL if it is yet to be created.
}
\section{About}{


    Daemons provide a potentially more efficient solution for async operations
    as new processes no longer need to be created on an ad hoc basis.

    Specifying '.url' also allows tasks to be distributed across the network.
    The network topology is such that server daemons dial into the client
    socket. In this way, network resources may be easily added or removed at
    any time.

    The current implementation is low-level and ensures tasks are
    evenly-distributed amongst daemons without actively managing a task queue.
    This approach provides a robust and resource-light solution, particularly
    well-suited to working with similar-length tasks, or where the number of
    concurrent tasks typically does not exceed the number of available
    daemons.
}

\examples{
if (interactive()) {
# Only run examples in interactive R sessions

# Create 4 daemons
daemons(4)
# View the number of active daemons
daemons("view")
# Reset to zero
daemons(0)

}

}
