% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{collect_mirai}
\alias{collect_mirai}
\title{mirai (Collect Value)}
\usage{
collect_mirai(x, ...)
}
\arguments{
\item{x}{a \sQuote{mirai} object, or list of \sQuote{mirai} objects.}

\item{...}{(if \sQuote{x} is a list of mirai) any of the collection options
for \code{\link{mirai_map}}, such as \code{\link{.flat}}.}
}
\value{
An object (the return value of the \sQuote{mirai}), or a list of such
  objects (the same length as \sQuote{x}, preserving names).
}
\description{
Waits for the \sQuote{mirai} to resolve if still in progress, and returns its
value directly. It is a more efficient version of and equivalent to
\code{call_mirai_(x)$data}.
}
\details{
This function will wait for the asynchronous operation(s) to complete if
still in progress, blocking but interruptible.

\code{x[]} may also be used to wait for and return the value of a mirai
\code{x}, and is equivalent to \code{collect_mirai(x)}.
}
\section{Alternatively}{


The value of a \sQuote{mirai} may be accessed at any time at \code{$data},
and if yet to resolve, an \sQuote{unresolved} logical NA will be returned
instead.

Using \code{\link{unresolved}} on a \sQuote{mirai} returns TRUE only if it
has yet to resolve and FALSE otherwise. This is suitable for use in control
flow statements such as \code{while} or \code{if}.
}

\section{Errors}{


If an error occurs in evaluation, the error message is returned as a
character string of class \sQuote{miraiError} and \sQuote{errorValue} (the
stack trace is available at \code{$stack.trace} on the error object).
\code{\link{is_mirai_error}} may be used to test for this.

If a daemon crashes or terminates unexpectedly during evaluation, an
\sQuote{errorValue} 19 (Connection reset) is returned.

\code{\link{is_error_value}} tests for all error conditions including
\sQuote{mirai} errors, interrupts, and timeouts.
}

\examples{
if (interactive()) {
# Only run examples in interactive R sessions

# using collect_mirai()
df1 <- data.frame(a = 1, b = 2)
df2 <- data.frame(a = 3, b = 1)
m <- mirai(as.matrix(rbind(df1, df2)), df1 = df1, df2 = df2, .timeout = 1000)
collect_mirai(m)

# using x[]
m[]

# mirai_map with collection options
daemons(1, dispatcher = FALSE)
m <- mirai_map(1:3, rnorm)
collect_mirai(m, .flat, .progress)
daemons(0)

}

}
