% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirtjml_conf.R
\name{mirtjml_conf}
\alias{mirtjml_conf}
\title{Constrained joint maximum likelihood estimation for confirmatory item factor analysis on the multidimensional two parameter logistic model.}
\usage{
mirtjml_conf(
  response,
  Q,
  theta0,
  A0,
  d0,
  cc = NULL,
  tol = 5,
  print_proc = TRUE
)
}
\arguments{
\item{response}{N by J matrix containing 0/1/NA responses, where N is the number of respondents, J is the number of items, and NA indicates a missing response.}

\item{Q}{J by K matrix containing 0/1 entries, where J is the number of items and K is the number of latent traits. Each entry indicates whether an item measures a certain latent trait.}

\item{theta0}{N by K matrix, the initial value of latent factor scores for each respondent.}

\item{A0}{J by K matrix, the initial value of loading matrix, satisfying the constraints given by Q.}

\item{d0}{Length J vector, the initial value of intercept parameters.}

\item{cc}{A constant constraining the magnitude of the norms of person and item parameter vectors.}

\item{tol}{The tolerance for convergence with a default value 5.}

\item{print_proc}{Print the precision during the estimation procedure with a default value TRUE.}
}
\value{
The function returns a list with the following components:
\describe{
  \item{theta_hat}{The estimated person parameter matrix.}
  \item{A_hat}{The estimated loading parameter matrix}
  \item{d_hat}{The estimated intercept parameters.}
}
}
\description{
Constrained joint maximum likelihood estimation for confirmatory item factor analysis on the multidimensional two parameter logistic model.
}
\examples{
# load a simulated dataset
attach(data_sim)

# generate starting values for the algorithm
A0 <- Q
d0 <- rep(0, J)
theta0 <- matrix(rnorm(N*K, 0, 1),N)

# use all available cores by running
# setMIRTthreads(-1)

# run the confirmatory analysis
res_conf <- mirtjml_conf(response, Q, theta0, A0, d0)


}
\references{
Chen, Y., Li, X., & Zhang, S. (2019). Structured Latent Factor Analysis for Large-scale Data: Identifiability, Estimability, and Their Implications. 
\emph{Journal of the American Statistical Association} <doi: 10.1080/01621459.2019.1635485>.
}
