% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.miss.lm.R
\name{predict.miss.lm}
\alias{predict.miss.lm}
\title{Prediction on test with missing values for the logistic regression model.}
\usage{
\method{predict}{miss.lm}(object, newdata = NULL, seed = NA, ...)
}
\arguments{
\item{object}{a fitted object of class inheriting from "miss.lm".}

\item{newdata}{a data frame in which to look for variables with which to predict. It can contain missing values.}

\item{seed}{An integer as a seed set for the random generator.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
\item{pr.y}{The prediction result for linear regression.}
}
\description{
Prediction on test with missing values for the logistic regression model.
}
\examples{




# Generate complete data
set.seed(1)
mu.X <- c(1, 1)
Sigma.X <- matrix(c(1, 1, 1, 4), nrow = 2)
n <- 50 # train set size
p <- 2 # number of covariates
X.complete <- matrix(rnorm(n*p), nrow=n)\%*\%chol(Sigma.X) +
              matrix(rep(mu.X,n), nrow=n, byrow = TRUE)
b <- c(2, 3, -1)
sigma.eps <- 0.25
y <- cbind(rep(1, n), X.complete) \%*\% b +
  rnorm(n, 0, sigma.eps)

# Add missing values
p.miss <- 0.10
patterns <- runif(n*p)<p.miss #missing completely at random
X.obs <- X.complete
X.obs[patterns] <- NA
# Estimate regression using EM
df.obs = data.frame(y ,X.obs)
miss.list = miss.lm(y~., data=df.obs)

# Generate new dataset for prediction
nt <- 20
Xt <- matrix(rnorm(nt*p), nrow=nt)\%*\%chol(Sigma.X)+
  matrix(rep(mu.X,nt), nrow=nt, byrow = TRUE)
# Generate missingness in new dataset
patterns <- runif(nt*p)<p.miss
Xt.obs <- Xt
Xt.obs[patterns] <- NA

# Prediction with missing values
miss.pred = predict(miss.list, data.frame(Xt.obs))
print(miss.pred)
}
