% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textable.R
\name{textable}
\alias{textable}
\title{Table to Latex}
\usage{
textable(d, file, caption = NULL, label = NULL, align = NULL,
  rownames = FALSE, topcapt = TRUE, digits = NULL, as.document = FALSE,
  landscape = FALSE, margin = 2, pt.size = 10, cmd = NULL, ...)
}
\arguments{
\item{d}{Object (will be coerced to data.frame) to transform to a latex table.}

\item{file}{Character string with output file name. If missing or \code{""},
the output is printed to the screen.}

\item{caption}{Character vector with title of table.}

\item{label}{Character vector with the latex label or HTML anchor.}

\item{align}{Character vector with \code{'l'}, \code{'c'}, \code{'r'}
for aligning the columns left, centered or right. Length is either one
or 1 (for rownames column) + number of columns in \code{d} (even if
\code{rownames = FALSE})}

\item{rownames}{Logical, include row names of \code{d}.}

\item{topcapt}{Logical, put caption and label before 'tabular'.}

\item{digits}{Number of digits to print from numeric values.}

\item{as.document}{Logical. \code{TRUE} to add the document definition to
the output. The document class is an article and the package a4paper is
included.}

\item{landscape}{Logical, use a landscape format for wider tables.
Only with \code{as.document=TRUE}.}

\item{margin}{Margin between table and page border in cm.
Only with \code{as.document=TRUE}.}

\item{pt.size}{Integer from 10 to 13 for the size of the characters.
Only with \code{as.document=TRUE}.}

\item{cmd}{A character vector with the system command to apply
on the output file. Only if \code{file} is given and \code{as.document}
is \code{TRUE}. \code{NULL} or an empty string \link{system} is not called.}

\item{...}{Forwarded arguments to \link[xtable]{print.xtable}.}
}
\value{
Returns a character vector invisible. If \code{file} is set, then the
content is written to a file. Else it is printed to the console.
}
\description{
This function enhances \code{xtable}: It can write the latex code of the
table directly to a file and optionally adds a header/footer for the
document structure. Also a system command can be given to convert the
tex file to a pdf document, for example.
}
\details{
Example for a system call:\cr
\code{cmd = "pdflatex -output-directory /path/to/files/"}
}
\examples{
#

\dontrun{
d <- head(trees)
dc <- 'R "trees" dataset.'
textable(d, rownames=TRUE, digits=4, caption=dc)
textable(d, '/tmp/trees.tex', caption=dc, as.document=TRUE, 
  cmd='pdflatex --output-directory /tmp')
}

#
}
\seealso{
\link{xtable}
}
\author{
Sven E. Templer
}
