% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-var.R
\name{gtrack.var.set}
\alias{gtrack.var.set}
\title{Assigns value to a track variable}
\usage{
gtrack.var.set(track = NULL, var = NULL, value = NULL)
}
\arguments{
\item{track}{track name}

\item{var}{track variable name}

\item{value}{value}
}
\value{
None.
}
\description{
Assigns value to a track variable.
}
\details{
This function creates a track variable and assigns 'value' to it. If the
track variable already exists its value is overwritten.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gtrack.var.set("sparse_track", "test_var", 1:10)
gtrack.var.get("sparse_track", "test_var")
gtrack.var.rm("sparse_track", "test_var")

}
\seealso{
\code{\link{gtrack.var.get}}, \code{\link{gtrack.var.ls}},
\code{\link{gtrack.var.rm}}
}
\keyword{~variable}
