% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-array.R
\name{gtrack.array.set_colnames}
\alias{gtrack.array.set_colnames}
\title{Sets column names of array track}
\usage{
gtrack.array.set_colnames(track = NULL, names = NULL)
}
\arguments{
\item{track}{track name}

\item{names}{vector of column names}
}
\value{
None.
}
\description{
Sets column names of array track.
}
\details{
This sets the column names of an array track.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

old.names <- gtrack.array.get_colnames("array_track")
new.names <- paste("modified", old.names, sep = "_")
gtrack.array.set_colnames("array_track", new.names)
gtrack.array.get_colnames("array_track")
gtrack.array.set_colnames("array_track", old.names)
gtrack.array.get_colnames("array_track")

}
\seealso{
\code{\link{gtrack.array.get_colnames}},
\code{\link{gtrack.array.extract}}, \code{\link{gvtrack.array.slice}},
\code{\link{gtrack.info}}
}
\keyword{~array}
\keyword{~columns}
