% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.cor.R
\name{size.cor}
\alias{size.cor}
\title{Sample size determination for testing Pearson's correlation coefficient}
\usage{
size.cor(rho = NULL, delta, alternative = c("two.sided", "less", "greater"),
         alpha = 0.05, beta = 0.1, check = TRUE, output = TRUE)
}
\arguments{
\item{rho}{a number indicating the correlation coefficient under the null hypothesis, \eqn{\rho}.0.}

\item{delta}{a numeric value indicating the minimum difference to be detected, \eqn{\delta}.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{alpha}{type-I-risk, \eqn{\alpha}.}

\item{beta}{type-II-risk, \eqn{\beta}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown.}
}
\value{
Returns an object of class \code{size} with following entries:

\tabular{ll}{
  \code{call}      \tab function call \cr
  \code{type}      \tab type of the test (i.e., correlation coefficient) \cr
  \code{spec}      \tab specification of function arguments \cr
  \code{res}       \tab list with the result, i.e., optimal sample size \cr
}
}
\description{
This function performs sample size computation for testing Pearson's product-moment correlation coefficient
based on precision requirements (i.e., type-I-risk, type-II-risk and an effect size).
}
\examples{
#--------------------------------------
# H0: rho = 0.3, H1: rho != 0.3
# alpha = 0.05, beta = 0.2, delta = 0.2

size.cor(rho = 0.3, delta = 0.2, alpha = 0.05, beta = 0.2)

#--------------------------------------
# H0: rho <= 0.3, H1: rho > 0.3
# alpha = 0.05, beta = 0.2, delta = 0.2

size.cor(rho = 0.3, delta = 0.2, alternative = "greater", alpha = 0.05, beta = 0.2)
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.

Rasch, D., Pilz, J., Verdooren, L. R., & Gebhardt, G. (2011).
\emph{Optimal experimental design with R}. Boca Raton: Chapman & Hall/CRC.
}
\seealso{
\code{\link{size.mean}}, \code{\link{size.prop}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
}
