## last modified June 2002

testconstr <- function(mixdat, mixpar, dist, constr) 
{
    validconstr <- TRUE
    if (constr$conpi == "PFX" & is.null(constr$fixpi)) 
        stop("PFX needs fixpi.")
    else if (constr$conpi == "PFX" & nrow(mixpar) != length(constr$fixpi)) 
        stop("fixpi was invalid with the mixpar.")
    else if (constr$conmu == "MFX" & is.null(constr$fixmu)) 
        stop("MFX needs fixmu.")
    else if (constr$conmu == "MFX" & nrow(mixpar) != length(constr$fixmu)) 
        stop("fixmu was invalid with the mixpar.")
    else if (constr$consigma == "SFX" & is.null(constr$fixsigma)) 
        stop("SFX needs fixsigma.")
    else if (constr$consigma == "SFX" & nrow(mixpar) != length(constr$fixsigma)) 
        stop("fixsigma was invalid with the mixpar.")
    else if (constr$consigma == "BINOM" & is.null(constr$size)) 
        stop("BINOM needs size.")
    else if (constr$consigma == "BINOM" & nrow(mixpar) != length(constr$size)) 
        stop("size was invalid with the mixpar.")
    else if (constr$consigma == "NBINOM" & is.null(constr$size)) 
        stop("NBINOM needs size.")
    else if (constr$consigma == "NBINOM" & nrow(mixpar) != length(constr$size)) 
        stop("size was invalid with the mixpar.")
    else if (constr$conmu == "MEQ" & constr$consigma == "SEQ") 
        stop("MEQ cannot have SEQ.")
    else if (constr$conmu == "MEQ" & constr$consigma == "FCV") 
        stop("MEQ cannot have FCV.")
    else if (constr$conmu == "MEQ" & constr$consigma == "CCV") 
        stop("MEQ cannot have CCV.")
    else if (constr$conmu == "MEQ" & constr$consigma == "POIS") 
        stop("MEQ cannot have POIS.")
    else if (mixpar[1, 2] <= 0 & !is.na(match(constr$consigma, 
        c("FCV", "CCV", "BINOM", "NBINOM", "POIS")))) 
        stop("FCV, CCV, BINOM, NBINOM and POIS must have positive means.")
    else if (mixpar[1, 2] <= 0 & !is.na(match(dist, c("lnorm", 
        "gamma", "weibull")))) 
        stop("Lognormal, gamma and weibull must have positive means.")
    else if (mixpar[1, 2] < 0 & !is.na(match(dist, c("binom", 
        "nbinom", "pois")))) 
        stop("Binomial, negative binomial and poisson can't have negative means.")
    else if (mixdat[1, 1] <= 0 & !is.na(match(dist, c("lnorm", 
        "gamma", "weibull")))) 
        stop("Lognormal, gamma and weibull must have positive data.")
    else if (mixdat[1, 1] < 0 & !is.na(match(dist, c("binom", 
        "nbinom", "pois")))) 
        stop("Binomial, negative binomial and poisson can't have negative data.")
    else if (dist == "binom" & constr$consigma != "BINOM") 
        stop("Binomial needs consigma = BINOM.")
    else if (dist == "pois" & constr$consigma != "POIS") 
        stop("Poisson needs consigma = POIS.")
    else if (dist == "nbinom" & constr$consigma == "BINOM") 
        stop("Negative binomial can't have consigma = BINOM.")
    else if (dist == "nbinom" & constr$consigma == "POIS") 
        stop("Negative binomial can't have consigma = POIS.")
    else if (nrow(mixpar) < 2 & constr$conmu == "MES") 
        stop("MES needs more components.")
    else if (nrow(mixpar) < 2 & constr$consigma == "CCV") 
        stop("CCV needs more components.")
    else if (nrow(mixpar) < 3 & constr$conmu == "MGC") 
        stop("MGC needs more components.")
    else validconstr
}
