% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_2vars.R
\name{plot_1num1fac}
\alias{plot_1num1fac}
\title{Box plots with points for one numeric variable vs one factor (or integer) variable.}
\usage{
plot_1num1fac(
  imputation.list,
  var.num,
  var.fac,
  original.data,
  true.data = NULL,
  color.pal = NULL,
  shape = FALSE
)
}
\arguments{
\item{imputation.list}{A list of \code{m} imputed datasets returned by the \code{mixgb} imputer}

\item{var.num}{A numeric variable}

\item{var.fac}{A factor variable}

\item{original.data}{The original data with missing data}

\item{true.data}{The true data without missing values. In general, this is unknown. Only use for simulation studies.}

\item{color.pal}{A vector of hex color codes for the observed and m sets of imputed values panels. The vector should be of length \code{m+1}. Default: NULL (use "gray40" for the observed panel, use ggplot2 default colors for other panels.)}

\item{shape}{Whether to plot shapes for different types of missing values. By default, this is set to FALSE to speed up plotting. We only recommend using `shape = TRUE` for small datasets.}
}
\value{
Box plot with jittered data points for a numeric/integer variable; Bar plot for a categorical variable.
}
\description{
Plot observed values versus m sets of imputed values for one numeric variable vs one factor (or integer) variable using \pkg{ggplot2}.
}
\examples{
# obtain m multiply datasets
imputed.data <- mixgb(data = nhanes3, m = 2)

# plot the multiply imputed values for variables "BMPHEAD" versus "HSSEX"
plot_1num1fac(
  imputation.list = imputed.data, var.num = "BMPHEAD", var.fac = "HSSEX",
  original.data = nhanes3
)
}
