% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compiler.R
\name{specify_model}
\alias{specify_model}
\title{Validate the utility functions against the dataset and generate the optimised logliklihood function}
\usage{
specify_model(utility_script, dataset = NULL, output_file = NULL,
  compile = TRUE, model_name = "mixl_model")
}
\arguments{
\item{utility_script}{The utility script to be compiled}

\item{dataset}{An (optional) dataframe to check if the all the variables are present}

\item{output_file}{An (optional) location where the compiled code should be saved (useful for debugging}

\item{compile}{If compile is false, then the code will not be compiled, but just validated and saved if an \code{output_file} is specified}

\item{model_name}{A name for the model, which will be used for saving. Defaults to *mixl_model*}
}
\value{
An \code{object} which contains the loglikelihood function, and information from the compile process
}
\description{
This function takes a utility function description, and generates a optimised C++ version 
of the utility function which can be called from R. If the data_names are provided, then the variables
in the function are checked against those provided. If an \code{output_file} is provided, the C++ code is saved there. 
See the user guide vignette for how to write valid utility scripts. There is some minimal specific syntax required.
}
\examples{
\donttest{
	data("Train", package="mlogit")
	Train$ID <- Train$id
	Train$CHOICE <- as.numeric(Train$choice)
	    
	mnl_test <- "
	U_A = @B_price * $price_A / 1000 + @B_time * $time_A / 60;
	U_B = @asc + @B_price * $price_B / 1000 + @B_timeB * $time_B / 60;
	"

	model_spec <- mixl::specify_model(mnl_test, Train)

	#only take starting values that are needed
	est <- stats::setNames(c(1, 1,1,1), c("asc", "B_price", "B_time", "B_timeB"))
	availabilities <- mixl::generate_default_availabilities(
		Train, model_spec$num_utility_functions)

	model <- mixl::estimate(model_spec, est, Train, availabilities = availabilities)
	print(model)
}
}
\seealso{
browseVignettes("mixl")
}
