\name{qq.mix}
\alias{qq.mix}
\title{
Draw a normal quantile-quantile plot of the residuals from
a fitted mixture of linear regressions.
}
\description{
Draws a normal quantile-quantile plot using symbols
whose size is proportional to the probability that the associated
observation was generated by the associated component of the model.
}
\usage{
qq.mix(object, xlim=NULL, ylim=NULL, shape="disc", ngon=20,
       size=1, \dots)
}
\arguments{
\item{object}{
A list with components containing the residuals, the relevant
probabilities, the predictors, and the observations, as returned
by resid.mix; probably the residuals should be standardized for
use by qq.mix, i.e. resid.mix should be called with std=TRUE.
}
\item{xlim}{
The limits (endpoints) of the x axis of the plot; chosen in
the "usual" way by the plotting software if xlim is NULL.
}
\item{ylim}{
The limits (endpoints) of the y axis of the plot; chosen in
the "usual" way by the plotting software if ylim is NULL.
}
\item{shape}{
The shape of the plotting symbol; possible values are "disc",
"square", and "diamond".  Partial matching is used so only
the first few letters need be given.
}
\item{ngon}{
The "disc" shape is actually a regular polygon; ngon specifies
how many sides it should have; ignored if shape is not equal
to "disc".
}
\item{size}{
A scale factor to change the absolute sizes of the plotting
symbols; values larger than 1 make the symbols larger than
the default; values less than 1 make them smaller.
}
\item{...}{
Additional arguments to be passed to the polygon function which
actually draws the plotting symbols.
}}
\section{Side Effects}{
A normal quantile-quantile plot is drawn in whatever device
is currently open.
}
\details{
The plot produced is visually assessed by ignoring or discounting
small symbols.
}
\author{Rolf Turner
  \email{r.turner@auckland.ac.nz}
  \url{http://www.stat.auckland.ac.nz/~rolf}
}
\references{
Turner, T. R.  (2000) Estimating the rate of spread of a viral infection
of potato plants via mixtures of regressions.  Appl. Statist. vol. 49,
Part 3, pp. 371 -- 384.
}
\section{ACKNOWLEDGEMENT}{
The idea of creating quantile-quantile plots for regression mixtures
by making the symbol size proportional to the associated probability
is due to Adrian Baddeley of the University of Western Australia
}
\seealso{
\link{bootcomp}, \link{cband}, \link{covmix}, \link{mixreg},
\link{plot.cband}, \link{plot.mresid}, \link{resid.mix}
}
\examples{
#See \link{mixreg} for examples.
}
% Converted by Sd2Rd version 1.21.
\keyword{models}
\keyword{regression}
\keyword{hplot}
