% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\docType{methods}
\name{setBackground}
\alias{setBackground}
\alias{setBackground,MizerParams-method}
\alias{setBackground,MizerSim-method}
\title{Designate species as background species}
\usage{
setBackground(object, ...)

\S4method{setBackground}{MizerParams}(object,
  species = object@species_params$species)

\S4method{setBackground}{MizerSim}(object,
  species = object@params@species_params$species)
}
\arguments{
\item{object}{An object of class \linkS4class{MizerParams} or 
\linkS4class{MizerSim}.}

\item{...}{Other arguments (unused)}

\item{species}{Name or vector of names of the species to be designated as
background species. By default this is set to all species.}
}
\value{
An object of the same class as the \code{object} argument
}
\description{
Background species are handled differently in some plots and their
abundance is automatically adjusted in addSpecies() to keep the community
close to the Sheldon spectrum.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
sim <- project(params, effort=1, t_max=20, t_save = 0.2)
sim <- setBackground(sim, species = c("Sprat", "Sandeel", 
                                            "N.pout", "Dab", "Saithe"))
plotSpectra(sim)
}
}
