% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_params.R
\name{species_params}
\alias{species_params}
\alias{species_params<-}
\alias{given_species_params}
\alias{given_species_params<-}
\alias{calculated_species_params}
\title{Species parameters}
\usage{
species_params(params)

species_params(params) <- value

given_species_params(params)

given_species_params(params) <- value

calculated_species_params(params)
}
\arguments{
\item{params}{A MizerParams object}

\item{value}{A data frame with the species parameters}
}
\value{
Data frame of species parameters
}
\description{
These functions allow you to get or set the species-specific parameters
stored in a MizerParams object.
}
\details{
There are a lot of species parameters and we will list them all below, but
most of them have sensible default values. The only required columns are
\code{species} for the species name and \code{w_max} for its maximum size. However
if you have information about the values of other parameters then you should
provide them.

Mizer distinguishes between the species parameters that you have given
explicitly and the species parameters that have been calculated by mizer or
set to default values. You can retrieve the given species parameters with
\code{given_species_params()} and the calculated ones with
\code{calculated_species_params()}. You get all species_params with
\code{species_params()}.

If you change given species parameters with \verb{given_species_params<-()} this
will trigger a re-calculation of the calculated species parameters, where
necessary. However if you change species parameters with \verb{species_params<-()}
no recalculation will take place and furthermore your values could be
overwritten by a future recalculation triggered by a call to
\verb{given_species_params<-()} . So in most use cases you will only want to use
\verb{given_species_params<-()}.

There are some species parameters that are used to set up the
size-dependent parameters that are used in the mizer model:
\itemize{
\item \code{gamma} and \code{q} are used to set the search volume, see \code{\link[=setSearchVolume]{setSearchVolume()}}.
\item \code{h} and \code{n} are used to set the maximum intake rate, see \code{\link[=setMaxIntakeRate]{setMaxIntakeRate()}}.
\item \code{k}, \code{ks} and \code{p} are used to set activity and basic metabolic rate,
see \code{\link[=setMetabolicRate]{setMetabolicRate()}}.
\item \code{z0} is used to set the external mortality rate, see \code{\link[=setExtMort]{setExtMort()}}.
\item \code{w_mat}, \code{w_mat25}, \code{w_repro_max} and \code{m} are used to set the allocation to
reproduction, see \code{\link[=setReproduction]{setReproduction()}}.
\item \code{pred_kernel_type} specifies the shape of the predation kernel. The default
is a "lognormal", for other options see the "Setting predation kernel"
section in the help for \code{\link[=setPredKernel]{setPredKernel()}}.
\item \code{beta} and \code{sigma} are parameters of the lognormal predation kernel, see
\code{\link[=lognormal_pred_kernel]{lognormal_pred_kernel()}}. There will be other parameters if you are
using other predation kernel functions.
}

When you change one of the above species parameters using
\verb{given_species_params<-()} or \verb{species_params<-()}, the new value will be
used to update the corresponding size-dependent rates automatically, unless
you have set those size-dependent rates manually, in which case the
corresponding species parameters will be ignored.

There are some species parameters that are used directly in the model
rather than being used for setting up size-dependent parameters:
\itemize{
\item \code{alpha} is the assimilation efficiency, the proportion of the consumed
biomass that can be used for growth, metabolism and reproduction, see
the help for \code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}}.
\item \code{w_min} is the egg size.
\item \code{interaction_resource} sets the interaction strength with the resource,
see "Predation encounter" section in the help for \code{\link[=getEncounter]{getEncounter()}}.
\item \code{erepro} is the reproductive efficiency, the proportion of the energy
invested into reproduction that is converted to egg biomass, see
\code{\link[=getRDI]{getRDI()}}.
\item \code{Rmax} is the parameter in the Beverton-Holt density dependence added to
the reproduction, see \code{\link[=setBevertonHolt]{setBevertonHolt()}}. There will be other such
parameters if you use other density dependence functions, see the
"Density dependence" section in the help for \code{\link[=setReproduction]{setReproduction()}}.
}

Two parameters are used only by functions that need to convert between
weight and length:
\itemize{
\item \code{a} and \code{b} are the parameters in the allometric weight-length
relationship \eqn{w = a l ^ b}.
}

If you have supplied the \code{a} and \code{b} parameters, then you can replace weight
parameters like \code{w_max}, \code{w_mat}, \code{w_mat25}, \code{w_repro_max} and \code{w_min} by
their corresponding length parameters \code{l_max}, \code{l_mat}, \code{l_mat25},
\code{l_repro_max} and \code{l_min}.

The parameters that are only used to calculate default values for other
parameters are:
\itemize{
\item \code{f0} is the feeding level and is used to get a default value for the
coefficient of the search volume \code{gamma}, see \code{\link[=get_gamma_default]{get_gamma_default()}}.
\item \code{fc} is the critical feeding level below which the species can not
maintain itself. This is used to get a default value for the coefficient
\code{ks} of the metabolic rate, see \code{\link[=get_ks_default]{get_ks_default()}}.
\item \code{age_mat} is the age at maturity and is used to get a default value for
the coefficient \code{h} of the maximum intake rate, see \code{\link[=get_h_default]{get_h_default()}}.
}

Note that setting these parameters with \verb{species_params<-()} will have no
effect. You need to set them with \verb{given_species_params<-()} in order to
trigger a re-calculation of the other species parameters.

In the past, mizer also used the von Bertalanffy parameters \code{k_vb}, \code{w_inf}
and \code{t0} to determine a default for \code{h}. This is unreliable and is therefore
now deprecated.

There are other species parameters that are used in tuning the model to
observations:
\itemize{
\item \code{biomass_observed} and \code{biomass_cutoff} allow you to specify for each
species the total observed biomass above some cutoff size. This is
used by \code{\link[=calibrateBiomass]{calibrateBiomass()}} and \code{\link[=matchBiomasses]{matchBiomasses()}}.
\item \code{yield_observed} allows you to specify for each
species the total annual fisheries yield. This is
used by \code{\link[=calibrateYield]{calibrateYield()}} and \code{\link[=matchYields]{matchYields()}}.
}

Finally there are two species parameters that control the way the species are
represented in plots:
\itemize{
\item \code{linecolour} specifies the colour and can be any valid R colour value.
\item \code{linetype} specifies the line type ("solid", "dashed", "dotted", "dotdash",
"longdash", "twodash" or "blank")
}

Other species-specific information that is related to how the species is
fished is specified in a gear parameter data frame, see \code{\link[=gear_params]{gear_params()}}.
However in the case where each species is caught by only a single gear,
this information can also optionally be provided as species parameters and
\code{\link[=newMultispeciesParams]{newMultispeciesParams()}} will transfer them to the \code{gear_params} data frame.
However changing these parameters later in the species parameter data frames
will have no effect.

You are allowed to include additional columns in the species parameter
data frames. They will simply be ignored by mizer but will be stored in the
MizerParams object, in case your own code makes use of them.
}
\seealso{
\code{\link[=validSpeciesParams]{validSpeciesParams()}}, \code{\link[=setParams]{setParams()}}

Other functions for setting parameters: 
\code{\link{gear_params}()},
\code{\link{setExtEncounter}()},
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setMetabolicRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setSearchVolume}()}
}
\concept{functions for setting parameters}
