% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saem.R
\name{saem}
\alias{saem}
\alias{saem.mmkin}
\alias{print.saem.mmkin}
\alias{saemix_model}
\alias{saemix_data}
\alias{parms.saem.mmkin}
\title{Fit nonlinear mixed models with SAEM}
\usage{
saem(object, ...)

\method{saem}{mmkin}(
  object,
  transformations = c("mkin", "saemix"),
  error_model = "auto",
  degparms_start = numeric(),
  test_log_parms = TRUE,
  conf.level = 0.6,
  solution_type = "auto",
  covariance.model = "auto",
  omega.init = "auto",
  covariates = NULL,
  covariate_models = NULL,
  no_random_effect = NULL,
  error.init = c(1, 1),
  nbiter.saemix = c(300, 100),
  control = list(displayProgress = FALSE, print = FALSE, nbiter.saemix = nbiter.saemix,
    save = FALSE, save.graphs = FALSE),
  verbose = FALSE,
  quiet = FALSE,
  ...
)

\method{print}{saem.mmkin}(x, digits = max(3, getOption("digits") - 3), ...)

saemix_model(
  object,
  solution_type = "auto",
  transformations = c("mkin", "saemix"),
  error_model = "auto",
  degparms_start = numeric(),
  covariance.model = "auto",
  no_random_effect = NULL,
  omega.init = "auto",
  covariates = NULL,
  covariate_models = NULL,
  error.init = numeric(),
  test_log_parms = FALSE,
  conf.level = 0.6,
  verbose = FALSE,
  ...
)

saemix_data(object, covariates = NULL, verbose = FALSE, ...)

\method{parms}{saem.mmkin}(object, ci = FALSE, ...)
}
\arguments{
\item{object}{An \link{mmkin} row object containing several fits of the same
\link{mkinmod} model to different datasets}

\item{\dots}{Further parameters passed to \link[saemix:saemixModel]{saemix::saemixModel}.}

\item{transformations}{Per default, all parameter transformations are done
in mkin. If this argument is set to 'saemix', parameter transformations
are done in 'saemix' for the supported cases, i.e. (as of version 1.1.2)
SFO, FOMC, DFOP and HS without fixing \code{parent_0}, and SFO or DFOP with
one SFO metabolite.}

\item{error_model}{Possibility to override the error model used in the mmkin object}

\item{degparms_start}{Parameter values given as a named numeric vector will
be used to override the starting values obtained from the 'mmkin' object.}

\item{test_log_parms}{If TRUE, an attempt is made to use more robust starting
values for population parameters fitted as log parameters in mkin (like
rate constants) by only considering rate constants that pass the t-test
when calculating mean degradation parameters using \link{mean_degparms}.}

\item{conf.level}{Possibility to adjust the required confidence level
for parameter that are tested if requested by 'test_log_parms'.}

\item{solution_type}{Possibility to specify the solution type in case the
automatic choice is not desired}

\item{covariance.model}{Will be passed to \code{\link[saemix:saemixModel]{saemix::saemixModel()}}. Per
default, uncorrelated random effects are specified for all degradation
parameters.}

\item{omega.init}{Will be passed to \code{\link[saemix:saemixModel]{saemix::saemixModel()}}. If using
mkin transformations and the default covariance model with optionally
excluded random effects, the variances of the degradation parameters
are estimated using \link{mean_degparms}, with testing of untransformed
log parameters for significant difference from zero. If not using
mkin transformations or a custom covariance model, the default
initialisation of \link[saemix:saemixModel]{saemix::saemixModel} is used for omega.init.}

\item{covariates}{A data frame with covariate data for use in
'covariate_models', with dataset names as row names.}

\item{covariate_models}{A list containing linear model formulas with one explanatory
variable, i.e. of the type 'parameter ~ covariate'. Covariates must be available
in the 'covariates' data frame.}

\item{no_random_effect}{Character vector of degradation parameters for
which there should be no variability over the groups. Only used
if the covariance model is not explicitly specified.}

\item{error.init}{Will be passed to \code{\link[saemix:saemixModel]{saemix::saemixModel()}}.}

\item{nbiter.saemix}{Convenience option to increase the number of
iterations}

\item{control}{Passed to \link[saemix:saemix]{saemix::saemix}.}

\item{verbose}{Should we print information about created objects of
type \link[saemix:SaemixModel-class]{saemix::SaemixModel} and \link[saemix:SaemixData-class]{saemix::SaemixData}?}

\item{quiet}{Should we suppress the messages saemix prints at the beginning
and the end of the optimisation process?}

\item{x}{An saem.mmkin object to print}

\item{digits}{Number of digits to use for printing}

\item{ci}{Should a matrix with estimates and confidence interval boundaries
be returned? If FALSE (default), a vector of estimates is returned.}
}
\value{
An S3 object of class 'saem.mmkin', containing the fitted
\link[saemix:SaemixObject-class]{saemix::SaemixObject} as a list component named 'so'. The
object also inherits from 'mixed.mmkin'.

An \link[saemix:SaemixModel-class]{saemix::SaemixModel} object.

An \link[saemix:SaemixData-class]{saemix::SaemixData} object.
}
\description{
This function uses \code{\link[saemix:saemix]{saemix::saemix()}} as a backend for fitting nonlinear mixed
effects models created from \link{mmkin} row objects using the Stochastic Approximation
Expectation Maximisation algorithm (SAEM).
}
\details{
An mmkin row object is essentially a list of mkinfit objects that have been
obtained by fitting the same model to a list of datasets using \link{mkinfit}.

Starting values for the fixed effects (population mean parameters, argument
psi0 of \code{\link[saemix:saemixModel]{saemix::saemixModel()}} are the mean values of the parameters found
using \link{mmkin}.
}
\examples{
\dontrun{
ds <- lapply(experimental_data_for_UBA_2019[6:10],
 function(x) subset(x$data[c("name", "time", "value")]))
names(ds) <- paste("Dataset", 6:10)
f_mmkin_parent_p0_fixed <- mmkin("FOMC", ds,
  state.ini = c(parent = 100), fixed_initials = "parent", quiet = TRUE)
f_saem_p0_fixed <- saem(f_mmkin_parent_p0_fixed)

f_mmkin_parent <- mmkin(c("SFO", "FOMC", "DFOP"), ds, quiet = TRUE)
f_saem_sfo <- saem(f_mmkin_parent["SFO", ])
f_saem_fomc <- saem(f_mmkin_parent["FOMC", ])
f_saem_dfop <- saem(f_mmkin_parent["DFOP", ])
anova(f_saem_sfo, f_saem_fomc, f_saem_dfop)
anova(f_saem_sfo, f_saem_dfop, test = TRUE)
illparms(f_saem_dfop)
f_saem_dfop_red <- update(f_saem_dfop, no_random_effect = "g_qlogis")
anova(f_saem_dfop, f_saem_dfop_red, test = TRUE)

anova(f_saem_sfo, f_saem_fomc, f_saem_dfop)
# The returned saem.mmkin object contains an SaemixObject, therefore we can use
# functions from saemix
library(saemix)
compare.saemix(f_saem_sfo$so, f_saem_fomc$so, f_saem_dfop$so)
plot(f_saem_fomc$so, plot.type = "convergence")
plot(f_saem_fomc$so, plot.type = "individual.fit")
plot(f_saem_fomc$so, plot.type = "npde")
plot(f_saem_fomc$so, plot.type = "vpc")

f_mmkin_parent_tc <- update(f_mmkin_parent, error_model = "tc")
f_saem_fomc_tc <- saem(f_mmkin_parent_tc["FOMC", ])
anova(f_saem_fomc, f_saem_fomc_tc, test = TRUE)

sfo_sfo <- mkinmod(parent = mkinsub("SFO", "A1"),
  A1 = mkinsub("SFO"))
fomc_sfo <- mkinmod(parent = mkinsub("FOMC", "A1"),
  A1 = mkinsub("SFO"))
dfop_sfo <- mkinmod(parent = mkinsub("DFOP", "A1"),
  A1 = mkinsub("SFO"))
# The following fit uses analytical solutions for SFO-SFO and DFOP-SFO,
# and compiled ODEs for FOMC that are much slower
f_mmkin <- mmkin(list(
    "SFO-SFO" = sfo_sfo, "FOMC-SFO" = fomc_sfo, "DFOP-SFO" = dfop_sfo),
  ds, quiet = TRUE)
# saem fits of SFO-SFO and DFOP-SFO to these data take about five seconds
# each on this system, as we use analytical solutions written for saemix.
# When using the analytical solutions written for mkin this took around
# four minutes
f_saem_sfo_sfo <- saem(f_mmkin["SFO-SFO", ])
f_saem_dfop_sfo <- saem(f_mmkin["DFOP-SFO", ])
# We can use print, plot and summary methods to check the results
print(f_saem_dfop_sfo)
plot(f_saem_dfop_sfo)
summary(f_saem_dfop_sfo, data = TRUE)

# The following takes about 6 minutes
#f_saem_dfop_sfo_deSolve <- saem(f_mmkin["DFOP-SFO", ], solution_type = "deSolve",
#  control = list(nbiter.saemix = c(200, 80), nbdisplay = 10))

#saemix::compare.saemix(list(
#  f_saem_dfop_sfo$so,
#  f_saem_dfop_sfo_deSolve$so))

# If the model supports it, we can also use eigenvalue based solutions, which
# take a similar amount of time
#f_saem_sfo_sfo_eigen <- saem(f_mmkin["SFO-SFO", ], solution_type = "eigen",
#  control = list(nbiter.saemix = c(200, 80), nbdisplay = 10))
}
}
\seealso{
\link{summary.saem.mmkin} \link{plot.mixed.mmkin}
}
