% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLUL.R
\name{MLUL}
\alias{MLUL}
\title{Multi-label undersampling based on local label imbalance (MLUL)}
\source{
Liu, B., Blekas, K., & Tsoumakas, G. (2022). Multi-label sampling based on local label imbalance. Pattern Recognition, 122, 108294.
}
\usage{
MLUL(D, P, k, neighbors = NULL, tableVDM = NULL)
}
\arguments{
\item{D}{mld \code{mldr} object with the multilabel dataset to preprocess}

\item{P}{Percentage in which the original dataset is decreased}

\item{k}{Number of neighbors to be considered when computing the neighbors of an instance}

\item{neighbors}{Structure with all instances and neighbors in the dataset. If it is empty, it will be calculated by the function}

\item{tableVDM}{Dataframe object containing previous calculations for faster processing. If it is empty, the algorithm will be slower}
}
\value{
A mld object containing the preprocessed multilabel dataset
}
\description{
This function implements the MLUL algorithm. It is a preprocessing algorithm for imbalanced multilabel datasets, which applies undersampling, removing difficult instances according to their neighbors.
}
