% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project-param.R
\name{mlflow_param}
\alias{mlflow_param}
\title{Read Command-Line Parameter}
\usage{
mlflow_param(name, default = NULL, type = NULL, description = NULL)
}
\arguments{
\item{name}{The name of the parameter.}

\item{default}{The default value of the parameter.}

\item{type}{Type of this parameter. Required if `default` is not set. If specified,
must be one of "numeric", "integer", or "string".}

\item{description}{Optional description for the parameter.}
}
\description{
Reads a command-line parameter passed to an MLflow project
MLflow allows you to define named, typed input parameters to your R scripts via the mlflow_param
API. This is useful for experimentation, e.g. tracking multiple invocations of the same script
with different parameters.
}
\examples{
\dontrun{
# This parametrized script trains a GBM model on the Iris dataset and can be run as an MLflow
# project. You can run this script (assuming it's saved at /some/directory/params_example.R)
# with custom parameters via:
# mlflow_run(entry_point = "params_example.R", uri = "/some/directory",
#   parameters = list(num_trees = 200, learning_rate = 0.1))
install.packages("gbm")
library(mlflow)
library(gbm)
# define and read input parameters
num_trees <- mlflow_param(name = "num_trees", default = 200, type = "integer")
lr <- mlflow_param(name = "learning_rate", default = 0.1, type = "numeric")
# use params to fit a model
ir.adaboost <- gbm(Species ~., data=iris, n.trees=num_trees, shrinkage=lr)
}

}
