% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_head_outliers.R
\name{get_head_outliers}
\alias{get_head_outliers}
\title{Detect Hydraulic Head Outliers}
\usage{
get_head_outliers(
  data = mlms::heads,
  vars = NULL,
  method = c("z-score", "IQR"),
  threshold = 3,
  multiplier = 1.5,
  min_n = 10L,
  quiet = TRUE
)
}
\arguments{
\item{data}{'data.frame' table.
Depth-discrete measurements of fluid pressure and temperature, hydraulic head values,
and land-surface atmospheric pressure measurements.
Defaults to the \code{\link{heads}} dataset.}

\item{vars}{'character' vector.
One or more variable names for which to compute summary statistics.
Choices include:
"total_head_va" is the hydraulic head in feet above the North American Vertical Datum of 1988,
"temp_va" is the fluid temperature in degree Celsius,
"baro_va" is the atmospheric pressure in pounds per square inch absolute (psi), and
"press_va" is the absolute fluid pressure in psi.
By default, all variables are included.}

\item{method}{'character' string.
Outlier detection method.
Specify "z-score" (default) for the standard score method, best suited for normally distributed data,
or "IQR" to use the IQR method, which is ideal for skewed distributions.}

\item{threshold}{'numeric' number.
Z-score value used to determine whether a parameter value is considered
an outlier or significantly different from the historic mean value.}

\item{multiplier}{'numeric' number.
Multiplier used to determine the threshold for outliers in the IQR method.}

\item{min_n}{'integer' number.
Minimum sample size needed to detect outliers.}

\item{quiet}{'logical' flag.
Whether to suppress printing of outlier information.}
}
\value{
A data frame with the following variables:
\describe{
\item{\code{var_ds}}{Variable description.}
\item{\code{var_nm}}{Variable name as specified in the \code{vars} argument.}
\item{\code{site_nm}}{Local site name for a MLMS well.}
\item{\code{port_nu}}{Identifier for the valved measurement port,
included only if the \code{by_port} argument is set to true (not the default).}
\item{\code{press_dt}}{Time at which measurements were measured outside the multiport casing.}
\item{\code{var_va}}{Parameter value.}
\item{\code{z_score}}{Z-score, a statistical measure that indicates how many standard deviations
a parameter value is from the mean.}
\item{\code{qu_1st}}{First quartile (25th percentile) of historical parameter values.}
\item{\code{qu_3rd}}{Third quartile (75th percentile) of historical parameter values.}
\item{\code{n}}{Sample size.}
}
}
\description{
Detect outliers in the fluid pressure data by comparing parameter values
against statistical metrics derived from the \code{\link{heads}} dataset.
This function will employ both the standard score (z-score) and Interquartile Range (IQR)
methods for outlier identification.
}
\examples{
d <- get_head_outliers()
str(d)

d <- get_head_outliers(method = "IQR")
str(d)
}
\seealso{
\code{\link{get_head_stats}} function is used to calculate the fluid pressure statistics.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
