% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CostSensClassifWrapper.R
\name{makeCostSensClassifWrapper}
\alias{makeCostSensClassifWrapper}
\alias{CostSensClassifWrapper}
\alias{CostSensClassifModel}
\title{Wraps a classification learner for use in cost-sensitive learning.}
\usage{
makeCostSensClassifWrapper(learner)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The classification learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}
}
\value{
[\code{\link{Learner}}].
}
\description{
Creates a wrapper, which can be used like any other learner object.
The classification model can easily be accessed via \code{\link{getLearnerModel}}.

This is a very naive learner, where the costs are transformed into classification labels -
the label for each case is the name of class with minimal costs.
(If ties occur, the label which is better on average w.r.t. costs over all training data is
preferred.)
Then the classifier is fitted to that data and subsequently used for prediction.
}
\seealso{
Other costsens: \code{\link{makeClassifTask}},
  \code{\link{makeCostSensRegrWrapper}},
  \code{\link{makeCostSensWeightedPairsWrapper}}

Other wrapper: \code{\link{makeBaggingWrapper}},
  \code{\link{makeConstantClassWrapper}},
  \code{\link{makeCostSensRegrWrapper}},
  \code{\link{makeDownsampleWrapper}},
  \code{\link{makeDummyFeaturesWrapper}},
  \code{\link{makeFeatSelWrapper}},
  \code{\link{makeFilterWrapper}},
  \code{\link{makeImputeWrapper}},
  \code{\link{makeMulticlassWrapper}},
  \code{\link{makeMultilabelBinaryRelevanceWrapper}},
  \code{\link{makeMultilabelClassifierChainsWrapper}},
  \code{\link{makeMultilabelDBRWrapper}},
  \code{\link{makeMultilabelNestedStackingWrapper}},
  \code{\link{makeMultilabelStackingWrapper}},
  \code{\link{makeOverBaggingWrapper}},
  \code{\link{makePreprocWrapperCaret}},
  \code{\link{makePreprocWrapper}},
  \code{\link{makeRemoveConstantFeaturesWrapper}},
  \code{\link{makeSMOTEWrapper}},
  \code{\link{makeTuneWrapper}},
  \code{\link{makeUndersampleWrapper}},
  \code{\link{makeWeightedClassesWrapper}}
}
