% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCritDifferences.R
\name{plotCritDifferences}
\alias{plotCritDifferences}
\title{Plot critical differences for a selected measure.}
\usage{
plotCritDifferences(obj, baseline = NULL, pretty.names = TRUE)
}
\arguments{
\item{obj}{[\code{critDifferencesData}]
Result of \link{generateCritDifferencesData} function.}

\item{baseline}{[\code{character(1)}]: [\code{learner.id}] \cr
Overwrites baseline from \link{generateCritDifferencesData}!\cr
Select a [\code{learner.id} as baseline for the critical difference
diagram, the critical difference will be positioned arround this learner.
Defaults to best performing algorithm.}

\item{pretty.names}{[\code{logical{1}}]\cr
Whether to use the short name of the learner instead of its ID in labels. Defaults to \code{TRUE}.}
}
\value{
ggplot2 plot object.
}
\description{
Plots a critical-differences diagram for all classifiers and
a selected measure. If a baseline is selected for the Bonferroni-Dunn
test, the critical difference interval will be positioned arround the baseline.
If not, the best performing algorithm will be chosen as baseline.
The positioning of some descriptive elements can be moved by modifying the
generated data.
}
\examples{
# see benchmark
}
\references{
Janez Demsar, Statistical Comparisons of Classifiers over Multiple Data Sets,
JMLR, 2006
}
\seealso{
Other plot: \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialDependenceGGVIS}},
  \code{\link{plotPartialDependence}},
  \code{\link{plotROCCurves}}, \code{\link{plotResiduals}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}

Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{batchmark}}, \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearnerShortNames}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}}, \code{\link{getBMRModels}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskDescs}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{reduceBatchmarkResults}}
}
