% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateLearningCurve.R
\name{generateLearningCurveData}
\alias{generateLearningCurveData}
\alias{LearningCurveData}
\title{Generates a learning curve.}
\usage{
generateLearningCurveData(learners, task, resampling = NULL,
  percs = seq(0.1, 1, by = 0.1), measures, stratify = FALSE,
  show.info = getMlrOption("show.info"))
}
\arguments{
\item{learners}{[(list of) [Learner])\cr
Learning algorithms which should be compared.}

\item{task}{(\link{Task})\cr
The task.}

\item{resampling}{([ResampleDesc] | [ResampleInstance])\cr
Resampling strategy to evaluate the performance measure.
If no strategy is given a default "Holdout" will be performed.}

\item{percs}{([numeric])\cr
Vector of percentages to be drawn from the training split.
These values represent the x-axis.
Internally [makeDownsampleWrapper] is used in combination with [benchmark].
Thus for each percentage a different set of observations is drawn resulting in noisy performance measures as the quality of the sample can differ.}

\item{measures}{[(list of) [Measure])\cr
Performance measures to generate learning curves for, representing the y-axis.}

\item{stratify}{(`logical(1)`)\cr
Only for classification:
Should the downsampled data be stratified according to the target classes?}

\item{show.info}{(\code{logical(1)})\cr
Print verbose output on console?
Default is set via \link{configureMlr}.}
}
\value{
([LearningCurveData]). A `list` containing:
  \item{task}{[[Task])\cr
    The task.}
  \item{measures}{[(list of) [Measure])\cr
    Performance measures.}
  \item{data}{([data.frame]) with columns:
    \itemize{
      \item `learner` Names of learners.
      \item `percentage` Percentages drawn from the training split.
      \item One column for each
    [Measure] passed to [generateLearningCurveData].
   }}
}
\description{
Observe how the performance changes with an increasing number of observations.
}
\examples{
r = generateLearningCurveData(list("classif.rpart", "classif.knn"),
task = sonar.task, percs = seq(0.2, 1, by = 0.2),
measures = list(tp, fp, tn, fn), resampling = makeResampleDesc(method = "Subsample", iters = 5),
show.info = FALSE)
plotLearningCurve(r)
}
\seealso{
Other generate_plot_data: \code{\link{generateCalibrationData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateFeatureImportanceData}},
  \code{\link{generateFilterValuesData}},
  \code{\link{generatePartialDependenceData}},
  \code{\link{generateThreshVsPerfData}},
  \code{\link{getFilterValues}},
  \code{\link{plotFilterValues}}

Other learning_curve: \code{\link{plotLearningCurve}}
}
