% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPredictType.R
\name{setPredictType}
\alias{setPredictType}
\title{Set the type of predictions the learner should return.}
\usage{
setPredictType(learner, predict.type)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}

\item{predict.type}{(\code{character(1)})\cr
Classification: \dQuote{response} or \dQuote{prob}.
Regression: \dQuote{response} or \dQuote{se}.
Survival: \dQuote{response} (linear predictor) or \dQuote{prob}.
Clustering: \dQuote{response} or \dQuote{prob}.
Default is \dQuote{response}.}
}
\value{
\link{Learner}.
}
\description{
Possible prediction types are:
Classification: Labels or class probabilities (including labels).
Regression: Numeric or response or standard errors (including numeric response).
Survival: Linear predictor or survival probability.

For complex wrappers the predict type is usually also passed down the
encapsulated learner in a recursive fashion.
}
\seealso{
Other predict: 
\code{\link{asROCRPrediction}()},
\code{\link{getPredictionProbabilities}()},
\code{\link{getPredictionResponse}()},
\code{\link{getPredictionTaskDesc}()},
\code{\link{predict.WrappedModel}()},
\code{\link{setPredictThreshold}()}

Other learner: 
\code{\link{LearnerProperties}},
\code{\link{getClassWeightParam}()},
\code{\link{getHyperPars}()},
\code{\link{getLearnerId}()},
\code{\link{getLearnerNote}()},
\code{\link{getLearnerPackages}()},
\code{\link{getLearnerParVals}()},
\code{\link{getLearnerParamSet}()},
\code{\link{getLearnerPredictType}()},
\code{\link{getLearnerShortName}()},
\code{\link{getLearnerType}()},
\code{\link{getParamSet}()},
\code{\link{helpLearnerParam}()},
\code{\link{helpLearner}()},
\code{\link{makeLearners}()},
\code{\link{makeLearner}()},
\code{\link{removeHyperPars}()},
\code{\link{setHyperPars}()},
\code{\link{setId}()},
\code{\link{setLearnerId}()},
\code{\link{setPredictThreshold}()}
}
\concept{learner}
\concept{predict}
