% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/setPredictType.R
\name{setPredictType}
\alias{setPredictType}
\title{Set the type of predictions the learner should return.}
\usage{
setPredictType(learner, predict.type)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{predict.type}{[\code{character(1)}]\cr
Classification: \dQuote{response} or \dQuote{prob}.
Regression: \dQuote{response} or \dQuote{se}.
Survival: \dQuote{response} (linear predictor) or \dQuote{prob}.
Clustering: \dQuote{response} or \dQuote{prob}.
Default is \dQuote{response}.}
}
\value{
[\code{\link{Learner}}].
}
\description{
Possible prediction types are:
Classification: Labels or class probabilities (including labels).
Regression: Numeric or response or standard errors (including numeric response).
Survival: Linear predictor or survival probability.

For complex wrappers the predict type is usually also passed down the
encapsulated learner in a recursive fashion.
}
\seealso{
Other learner: \code{\link{LearnerProperties}},
  \code{\link{addProperties}}, \code{\link{hasProperties}},
  \code{\link{removeProperties}},
  \code{\link{setProperties}}; \code{\link{Learner}},
  \code{\link{makeLearner}}; \code{\link{getHyperPars}};
  \code{\link{getParamSet}}; \code{\link{removeHyperPars}};
  \code{\link{setHyperPars}}; \code{\link{setId}};
  \code{\link{setPredictThreshold}};
  \code{\link{showHyperPars}}

Other predict: \code{\link{asROCRPrediction}};
  \code{\link{getProbabilities}};
  \code{\link{plotROCRCurves}};
  \code{\link{plotViperCharts}};
  \code{\link{predict.WrappedModel}};
  \code{\link{setPredictThreshold}}
}

