% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{mlr_assertions}
\alias{mlr_assertions}
\alias{assert_backend}
\alias{assert_task}
\alias{assert_tasks}
\alias{assert_learner}
\alias{assert_learners}
\alias{assert_measure}
\alias{assert_measures}
\alias{assert_resampling}
\alias{assert_resamplings}
\alias{assert_prediction}
\alias{assert_resample_result}
\alias{assert_benchmark_result}
\alias{assert_row_ids}
\title{Assertion for mlr3 Objects}
\usage{
assert_backend(b, .var.name = checkmate::vname(b), add = NULL)

assert_task(task, task_type = NULL, feature_types = NULL,
  task_properties = NULL, .var.name = checkmate::vname(task),
  add = NULL)

assert_tasks(tasks, task_type = NULL, feature_types = NULL,
  task_properties = NULL, .var.name = checkmate::vname(tasks),
  add = NULL)

assert_learner(learner, task = NULL, properties = character(),
  .var.name = checkmate::vname(learner), add = NULL)

assert_learners(learners, task = NULL, properties = character(),
  .var.name = checkmate::vname(learners), add = NULL)

assert_measure(measure, task = NULL, learner = NULL,
  .var.name = checkmate::vname(measure), add = NULL)

assert_measures(measures, task = NULL, learner = NULL,
  .var.name = checkmate::vname(measures), add = NULL)

assert_resampling(resampling, instantiated = NULL,
  .var.name = checkmate::vname(resampling), add = NULL)

assert_resamplings(resamplings, instantiated = NULL,
  .var.name = checkmate::vname(resamplings), add = NULL)

assert_prediction(prediction, .var.name = checkmate::vname(prediction),
  add = NULL)

assert_resample_result(rr, .var.name = checkmate::vname(rr),
  add = NULL)

assert_benchmark_result(bmr, .var.name = checkmate::vname(bmr),
  add = NULL)

assert_row_ids(row_ids, type = NULL, .var.name = vname(row_ids))
}
\arguments{
\item{b}{:: \link{DataBackend}.}

\item{task}{:: \link{Task}.}

\item{feature_types}{:: \code{character()}\cr
Set of allowed feature types.}

\item{task_properties}{:: \code{character()}\cr
Set of required task properties.}

\item{tasks}{:: list of \link{Task}.}

\item{learner}{:: \link{Learner}.}

\item{learners}{:: list of \link{Learner}.}

\item{measure}{:: \link{Measure}.}

\item{measures}{:: list of \link{Measure}.}

\item{resampling}{:: \link{Resampling}.}

\item{resamplings}{:: list of \link{Resampling}.}

\item{prediction}{:: \link{Prediction}.}

\item{bmr}{:: \link{BenchmarkResult}.}

\item{row_ids}{:: \code{vector()}.}

\item{resample_result}{:: \link{ResampleResult}.}
}
\description{
Functions intended to be used in packages extending \pkg{mlr3}.
All functions assert on the respective class, and optionally additional properties.
If an assertion fails, an exception is raised.
Otherwise, the input object is returned invisibly.
}
\keyword{internal}
