% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fselect_nested.R
\name{fselect_nested}
\alias{fselect_nested}
\title{Function for Nested Resampling}
\usage{
fselect_nested(
  fselector,
  task,
  learner,
  inner_resampling,
  outer_resampling,
  measure = NULL,
  term_evals = NULL,
  term_time = NULL,
  terminator = NULL,
  store_fselect_instance = TRUE,
  store_benchmark_result = TRUE,
  store_models = FALSE,
  check_values = FALSE,
  callbacks = list()
)
}
\arguments{
\item{fselector}{(\link{FSelector})\cr
Optimization algorithm.}

\item{task}{(\link[mlr3:Task]{mlr3::Task})\cr
Task to operate on.}

\item{learner}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Learner to optimize the feature subset for.}

\item{inner_resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling used for the inner loop.}

\item{outer_resampling}{\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling used for the outer loop.}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Measure to optimize. If \code{NULL}, default measure is used.}

\item{term_evals}{(\code{integer(1)})\cr
Number of allowed evaluations.
Ignored if \code{terminator} is passed.}

\item{term_time}{(\code{integer(1)})\cr
Maximum allowed time in seconds.
Ignored if \code{terminator} is passed.}

\item{terminator}{(\link{Terminator})\cr
Stop criterion of the feature selection.}

\item{store_fselect_instance}{(\code{logical(1)})\cr
If \code{TRUE} (default), stores the internally created \link{FSelectInstanceSingleCrit} with all intermediate results in slot \verb{$fselect_instance}.
Is set to \code{TRUE}, if \code{store_models = TRUE}}

\item{store_benchmark_result}{(\code{logical(1)})\cr
Store benchmark result in archive?}

\item{store_models}{(\code{logical(1)}).
Store models in benchmark result?}

\item{check_values}{(\code{logical(1)})\cr
Check the parameters before the evaluation and the results for
validity?}

\item{callbacks}{(list of \link{CallbackFSelect})\cr
List of callbacks.}
}
\value{
\link[mlr3:ResampleResult]{mlr3::ResampleResult}
}
\description{
Function to conduct nested resampling.
}
\examples{
# Nested resampling on Palmer Penguins data set
rr = fselect_nested(
  fselector = fs("random_search"),
  task = tsk("penguins"),
  learner = lrn("classif.rpart"),
  inner_resampling = rsmp ("holdout"),
  outer_resampling = rsmp("cv", folds = 2),
  measure = msr("classif.ce"),
  term_evals = 4)

# Performance scores estimated on the outer resampling
rr$score()

# Unbiased performance of the final model trained on the full data set
rr$aggregate()
}
