% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_auc.R
\name{auc}
\alias{auc}
\title{Area Under the ROC Curve}
\usage{
auc(truth, prob, positive, na_value = NaN, ...)
}
\arguments{
\item{truth}{:: \code{factor()}\cr
True (observed) labels.
Must have exactly same two levels and the same length as \code{response}.}

\item{prob}{:: \code{numeric()}\cr
Predicted probability for positive class.
Must have exactly same length as \code{truth}.}

\item{positive}{:: \code{character(1)}\cr
Name of the positive class.}

\item{na_value}{:: \code{numeric(1)}\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{...}{:: \code{any}\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Computes the area under the Receiver Operator Characteristic (ROC) curve.
The AUC can be interpreted as the probability that a randomly chosen positive observation
has a higher predicted probability than a randomly chosen negative observation.
}
\note{
This measure is undefined if the true values are either all positive or
all negative.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"binary"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{prob}
}
}

\examples{
truth = factor(c("a", "a", "a", "b"))
prob = c(.6, .7, .1, .4)
auc(truth, prob, "a")
}
\references{
\cite{youden_1950}
}
\seealso{
Other Binary Classification Measures: \code{\link{dor}},
  \code{\link{fbeta}}, \code{\link{fdr}},
  \code{\link{fnr}}, \code{\link{fn}}, \code{\link{fomr}},
  \code{\link{fpr}}, \code{\link{fp}}, \code{\link{mcc}},
  \code{\link{npv}}, \code{\link{ppv}}, \code{\link{tnr}},
  \code{\link{tn}}, \code{\link{tpr}}, \code{\link{tp}}
}
\concept{Binary Classification Measures}
\concept{binary_classification_measure}
