% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_fdr.R
\name{fdr}
\alias{fdr}
\title{False Discovery Rate}
\usage{
fdr(truth, response, positive, na_value = NaN, ...)
}
\arguments{
\item{truth}{:: \code{factor()}\cr
True (observed) labels.
Must have the exactly same two levels and the same length as \code{response}.}

\item{response}{:: \code{factor()}\cr
Predicted response labels.
Must have the exactly same two levels and the same length as \code{truth}.}

\item{positive}{:: \code{character(1)}\cr
Name of the positive class.}

\item{na_value}{:: \code{numeric(1)}\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{...}{:: \code{any}\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Binary classification measure defined as \deqn{
   \frac{\mathrm{FP}}{\mathrm{TP} + \mathrm{FP}}.
}{
   FP / (TP + FP).
}
}
\note{
This measure is undefined if TP + FP = 0.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"binary"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{TRUE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
lvls = c("a", "b")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
response = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
fdr(truth, response, positive = "a")
}
\references{
\url{https://en.wikipedia.org/wiki/Template:DiagnosticTesting_Diagram}
}
\seealso{
Other Binary Classification Measures: 
\code{\link{auc}()},
\code{\link{bbrier}()},
\code{\link{dor}()},
\code{\link{fbeta}()},
\code{\link{fnr}()},
\code{\link{fn}()},
\code{\link{fomr}()},
\code{\link{fpr}()},
\code{\link{fp}()},
\code{\link{mcc}()},
\code{\link{npv}()},
\code{\link{ppv}()},
\code{\link{tnr}()},
\code{\link{tn}()},
\code{\link{tpr}()},
\code{\link{tp}()}
}
\concept{Binary Classification Measures}
\concept{binary_classification_measure}
