% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif_zero_one.R
\name{zero_one}
\alias{zero_one}
\title{Zero-One Classification Loss (per observation)}
\usage{
zero_one(truth, response, ...)
}
\arguments{
\item{truth}{(\code{factor()})\cr
True (observed) labels.
Must have the same levels and length as \code{response}.}

\item{response}{(\code{factor()})\cr
Predicted response labels.
Must have the same levels and length as \code{truth}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(length(truth))}.
}
\description{
Calculates the per-observation 0/1 loss as \deqn{
  t_i \neq r_1.
}{
  t != r.
}

Measure to compare true observed labels with predicted
labels
in multiclass classification tasks.

Note that this is an unaggregated measure, returning the losses per observation.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"classif"}
\item Range (per observation): \eqn{[0, 1]}{[0, 1]}
\item Minimize (per observation): \code{TRUE}
\item Required prediction: \code{response}
}
}

\seealso{
Other Classification Measures: 
\code{\link{acc}()},
\code{\link{bacc}()},
\code{\link{ce}()},
\code{\link{logloss}()},
\code{\link{mauc_aunu}()},
\code{\link{mbrier}()}
}
\concept{Classification Measures}
\concept{classification_measure}
