% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity_jaccard.R
\name{jaccard}
\alias{jaccard}
\title{Jaccard Similarity Index}
\usage{
jaccard(sets, na_value = NaN, ...)
}
\arguments{
\item{sets}{(\code{list()})\cr
List of character or integer vectors.
\code{sets} must have at least 2 elements.}

\item{na_value}{(\code{numeric(1)})\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare two or more sets w.r.t. their similarity.
}
\details{
For two sets \eqn{A} and \eqn{B}, the Jaccard Index is defined as
\deqn{
  J(A, B) = \frac{|A \cap B|}{|A \cup B|}.
}{
  J(A, B) = length(intersect(A, B)) / length(union(A, B)).
}
If more than two sets are provided, the mean of all pairwise scores
is calculated.

This measure is undefined if two or more sets are empty.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"similarity"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
}
}

\examples{
set.seed(1)
sets = list(
  sample(letters[1:3], 1),
  sample(letters[1:3], 2)
)
jaccard(sets)
}
\references{
Jaccard, Paul (1901).
\dQuote{Étude comparative de la distribution florale dans une portion des Alpes et du Jura.}
\emph{Bulletin de la Société Vaudoise des Sciences Naturelles}, \bold{37}, 547-579.
\doi{10.5169/SEALS-266450}.

Bommert A, Rahnenführer J, Lang M (2017).
\dQuote{A Multicriteria Approach to Find Predictive and Sparse Models with Stable Feature Selection for High-Dimensional Data.}
\emph{Computational and Mathematical Methods in Medicine}, \bold{2017}, 1--18.
\doi{10.1155/2017/7907163}.

Bommert A, Lang M (2021).
\dQuote{stabm: Stability Measures for Feature Selection.}
\emph{Journal of Open Source Software}, \bold{6}(59), 3010.
\doi{10.21105/joss.03010}.
}
\seealso{
Package \CRANpkg{stabm} which implements many more stability measures with included
correction for chance.

Other Similarity Measures: 
\code{\link{phi}()}
}
\concept{Similarity Measures}
\concept{similarity_measure}
