% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_operators.R
\name{check_operators}
\alias{check_operators}
\alias{\%check&&\%}
\alias{\%check||\%}
\title{Logical Check Operators}
\usage{
lhs \%check&&\% rhs

lhs \%check||\% rhs
}
\arguments{
\item{lhs, rhs}{(\verb{function()})\cr
\verb{check_*}-functions that return either \code{TRUE} or an error message as a \code{character(1)}.}
}
\value{
Either \code{TRUE} or a \code{character(1)}.
}
\description{
Logical AND and OR operators for \verb{check_*}-functions from \code{\link[checkmate:checkmate-package]{checkmate}}.
}
\examples{
library(checkmate)

x = c(0, 1, 2, 3)
check_numeric(x) \%check&&\% check_names(names(x), "unnamed")  # is TRUE
check_numeric(x) \%check&&\% check_true(all(x < 0))  # fails

check_numeric(x) \%check||\% check_character(x)  # is TRUE
check_number(x) \%check||\% check_flag(x)  # fails
}
