% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep_in_bounds.R
\name{keep_in_bounds}
\alias{keep_in_bounds}
\title{Remove All Elements Out Of Bounds}
\usage{
keep_in_bounds(x, lower, upper)
}
\arguments{
\item{x}{(\code{integer()})\cr
Vector to filter.}

\item{lower}{(\code{integer(1)})\cr
Lower bound.}

\item{upper}{(\code{integer(1)})\cr
Upper bound.}
}
\value{
(integer()) with only values in \verb{[lower, upper]}.
}
\description{
Filters vector \code{x} to only keep elements which are in bounds \verb{[lower, upper]}.
This is equivalent to the following, but tries to avoid unnecessary allocations:\preformatted{ x[!is.na(x) & x >= lower & x <= upper]
}

Currently only works for integer \code{x}.
}
\examples{
keep_in_bounds(sample(20), 5, 10)
}
