% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpCopy.R
\docType{data}
\name{mlr_pipeops_copy}
\alias{mlr_pipeops_copy}
\alias{PipeOpCopy}
\title{PipeOpCopy}
\format{\code{\link{R6Class}} object inheriting from \code{\link{PipeOp}}.}
\description{
Copies its input \code{outnum} times. This PipeOp usually not needed,
because copying happens automatically when one \code{PipeOp} is followed
by multiple different \code{PipeOp}s. However, when constructing big
Graphs using the \code{\link{\%>>\%}}-operator, \code{PipeOpCopy} can be helpful to
specify which \code{\link{PipeOp}} gets connected to which.
}
\section{Construction}{
\preformatted{PipeOpEnsemble$new(outnum, id = "copy", param_vals = list())
}
\itemize{
\item \code{outnum} :: \code{numeric(1)}\cr
Number of output channels, and therefore number of copies being made.
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"copy"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

\code{\link{PipeOpCopy}} has one input channel named \code{"input"}, taking any input (\code{"*"}) both during training and prediction.

\code{\link{PipeOpCopy}} has multiple output channels depending on the \code{outnum} construction argument, named \code{"output1"}, \code{"output2"}, ...
All output channels produce the object given as input (\code{"*"}).
}

\section{State}{

The \code{$state} is left empty (\code{list()}).
}

\section{Parameters}{

\code{\link{PipeOpCopy}} has no parameters.
}

\section{Internals}{

Note that copies are not clones, but only reference copies. This affects
R6-objects: If R6 objects are copied using PipeOpCopy, they must be cloned
before
}

\section{Fields}{

Only fields inherited from \code{\link{PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOp}}.
}

\examples{
# The following copies the output of 'scale' automatically to both
# 'pca' and 'nop'
po("scale") \%>>\%
  gunion(list(
    po("pca"),
    po("nop")
  ))

# The following would not work: the '\%>>\%'-operator does not know
# which output to connect to which input
# > gunion(list(
# >   po("scale"),
# >   po("select")
# > )) \%>>\%
# >   gunion(list(
# >     po("pca"),
# >     po("nop"),
# >     po("imputemean")
# >   ))
# Instead, the 'copy' operator makes clear which output gets copied.
gunion(list(
  po("scale") \%>>\% mlr_pipeops$get("copy", outnum = 2),
  po("select")
)) \%>>\%
  gunion(list(
    po("pca"),
    po("nop"),
    po("imputemean")
  ))
}
\seealso{
Other PipeOps: \code{\link{PipeOpEnsemble}},
  \code{\link{PipeOpImpute}},
  \code{\link{PipeOpTaskPreproc}}, \code{\link{PipeOp}},
  \code{\link{mlr_pipeops_boxcox}},
  \code{\link{mlr_pipeops_branch}},
  \code{\link{mlr_pipeops_chunk}},
  \code{\link{mlr_pipeops_classbalancing}},
  \code{\link{mlr_pipeops_classifavg}},
  \code{\link{mlr_pipeops_classweights}},
  \code{\link{mlr_pipeops_colapply}},
  \code{\link{mlr_pipeops_collapsefactors}},
  \code{\link{mlr_pipeops_encodeimpact}},
  \code{\link{mlr_pipeops_encodelmer}},
  \code{\link{mlr_pipeops_encode}},
  \code{\link{mlr_pipeops_featureunion}},
  \code{\link{mlr_pipeops_filter}},
  \code{\link{mlr_pipeops_fixfactors}},
  \code{\link{mlr_pipeops_histbin}},
  \code{\link{mlr_pipeops_ica}},
  \code{\link{mlr_pipeops_imputehist}},
  \code{\link{mlr_pipeops_imputemean}},
  \code{\link{mlr_pipeops_imputemedian}},
  \code{\link{mlr_pipeops_imputenewlvl}},
  \code{\link{mlr_pipeops_imputesample}},
  \code{\link{mlr_pipeops_kernelpca}},
  \code{\link{mlr_pipeops_learner}},
  \code{\link{mlr_pipeops_missind}},
  \code{\link{mlr_pipeops_modelmatrix}},
  \code{\link{mlr_pipeops_mutate}},
  \code{\link{mlr_pipeops_nop}},
  \code{\link{mlr_pipeops_pca}},
  \code{\link{mlr_pipeops_quantilebin}},
  \code{\link{mlr_pipeops_regravg}},
  \code{\link{mlr_pipeops_removeconstants}},
  \code{\link{mlr_pipeops_scalemaxabs}},
  \code{\link{mlr_pipeops_scalerange}},
  \code{\link{mlr_pipeops_scale}},
  \code{\link{mlr_pipeops_select}},
  \code{\link{mlr_pipeops_smote}},
  \code{\link{mlr_pipeops_spatialsign}},
  \code{\link{mlr_pipeops_subsample}},
  \code{\link{mlr_pipeops_unbranch}},
  \code{\link{mlr_pipeops_yeojohnson}},
  \code{\link{mlr_pipeops}}

Other Placeholder Pipeops: \code{\link{mlr_pipeops_nop}}
}
\concept{PipeOps}
\concept{Placeholder Pipeops}
\keyword{datasets}
