% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_graphs_elements.R
\name{pipeline_stacking}
\alias{pipeline_stacking}
\title{Create A Graph to Perform Stacking.}
\usage{
pipeline_stacking(
  base_learners,
  super_learner,
  method = "cv",
  folds = 3,
  use_features = TRUE
)
}
\arguments{
\item{base_learners}{\code{list} of \code{\link[mlr3:Learner]{Learner}}\cr
A list of base learners.}

\item{super_learner}{\code{\link[mlr3:Learner]{Learner}}\cr
The super learner that makes the final prediction based on the base learners.}

\item{method}{\code{character(1)}\cr
\code{"cv"} (default) for building a super learner using cross-validated predictions of the
base learners or \code{"insample"} for building a super learner using the
predictions of the base learners trained on all training data.}

\item{folds}{\code{ìnteger(1)}\cr
Number of cross-validation folds. Only used for \code{method = "cv"}. Default 3.}

\item{use_features}{\code{logical(1)}\cr
Whether the original features should also be passed to the super learner.
Default \code{TRUE}.}
}
\value{
\code{\link{Graph}}
}
\description{
Create a new \code{\link{Graph}} for stacking. A stacked learner uses predictions of
several base learners and fits a super learner using these predictions as
features in order to predict the outcome.
}
\examples{
if (requireNamespace("kknn")) {
library(mlr3)
library(mlr3learners)

base_learners = list(
  lrn("classif.rpart", predict_type = "prob"),
  lrn("classif.kknn", predict_type = "prob")
)
super_learner = lrn("classif.log_reg")

graph_stack = pipeline_stacking(base_learners, super_learner)
graph_learner = as_learner(graph_stack)
graph_learner$train(tsk("iris"))
}
}
