% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpSurvAvg.R
\name{mlr_pipeops_survavg}
\alias{mlr_pipeops_survavg}
\alias{PipeOpSurvAvg}
\title{PipeOpSurvAvg}
\format{
\link{R6Class} inheriting from \link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}.
}
\description{
Perform (weighted) prediction averaging from survival \link{PredictionSurv}s by connecting
\code{PipeOpSurvAvg} to multiple \link[mlr3pipelines:PipeOpLearner]{PipeOpLearner} outputs.

The resulting prediction will aggregate any predict types that are contained within all inputs.
Any predict types missing from at least one input will be set to \code{NULL}. These are aggregated
as follows:
\itemize{
\item \code{"response"}, \code{"crank"}, and \code{"lp"} are all a weighted average from the incoming predictions.
\item \code{"distr"} is a \link[distr6:VectorDistribution]{distr6::VectorDistribution} containing \link[distr6:MixtureDistribution]{distr6::MixtureDistribution}s.
}

Weights can be set as a parameter; if none are provided, defaults to
equal weights for each prediction.
}
\section{Input and Output Channels}{

Input and output channels are inherited from \link[mlr3pipelines:PipeOpEnsemble]{PipeOpEnsemble}
with a \link{PredictionSurv} for inputs and outputs.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

The parameters are the parameters inherited from the
\link[mlr3pipelines:PipeOpEnsemble]{PipeOpEnsemble}.
}

\section{Internals}{

Inherits from \link[mlr3pipelines:PipeOpEnsemble]{PipeOpEnsemble} by implementing the
\code{private$weighted_avg_predictions()} method.
}

\section{Fields}{

Only fields inherited from
\link[mlr3pipelines:PipeOpEnsemble]{PipeOpEnsemble}/\link[mlr3pipelines:PipeOp]{PipeOp}.
}

\section{Methods}{

Only methods inherited from
\link[mlr3pipelines:PipeOpEnsemble]{PipeOpEnsemble}/\link[mlr3pipelines:PipeOp]{PipeOp}.
}

\examples{
\dontrun{
library(mlr3)
library(mlr3pipelines)
set.seed(1)

task = tgen("simsurv")$generate(10)
p1 = lrn("surv.coxph")$train(task)$predict(task)
p2 = lrn("surv.kaplan")$train(task)$predict(task)
poc = po("survavg", param_vals = list(weights = c(0.2, 0.8)))
poc$predict(list(p1, p2))
}
}
\concept{Ensembles}
\concept{PipeOps}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpEnsemble]{mlr3pipelines::PipeOpEnsemble}} -> \code{PipeOpSurvAvg}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpSurvAvg$new()}}
\item \href{#method-clone}{\code{PipeOpSurvAvg$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOpEnsemble" data-id="predict_internal">}\href{../../mlr3pipelines/html/PipeOpEnsemble.html#method-predict_internal}{\code{mlr3pipelines::PipeOpEnsemble$predict_internal()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOpEnsemble" data-id="train_internal">}\href{../../mlr3pipelines/html/PipeOpEnsemble.html#method-train_internal}{\code{mlr3pipelines::PipeOpEnsemble$train_internal()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpSurvAvg$new(innum = 0, id = "survavg", param_vals = list(), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{innum}}{\code{(numeric(1))}\cr
Determines the number of input channels.
If \code{innum} is 0 (default), a vararg input channel is created that can take an arbitrary
number of inputs.}

\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object, default \code{"survavg"}.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}

\item{\code{...}}{\code{ANY}\cr
Additional arguments passed to \link[mlr3pipelines:PipeOpEnsemble]{mlr3pipelines::PipeOpEnsemble}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpSurvAvg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
