% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{mlr3spatial-package}
\alias{mlr3spatial}
\alias{mlr3spatial-package}
\title{mlr3spatial: Support for Spatial Objects Within the 'mlr3' Ecosystem}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Extends the 'mlr3' ML framework with methods for spatial objects. Data storage and prediction are supported for packages 'terra', 'raster' and 'stars'.
}
\section{Learn mlr3}{

\itemize{
\item Book on mlr3: \url{https://mlr3book.mlr-org.com}
\item Use cases and examples gallery: \url{https://mlr3gallery.mlr-org.com}
\item Cheat Sheets: \url{https://github.com/mlr-org/mlr3cheatsheets}
}
}

\section{mlr3 extensions}{

\itemize{
\item Preprocessing and machine learning pipelines: \CRANpkg{mlr3pipelines}
\item Analysis of benchmark experiments: \CRANpkg{mlr3benchmark}
\item More classification and regression tasks: \CRANpkg{mlr3data}
\item Connector to \href{https://www.openml.org}{OpenML}: \CRANpkg{mlr3oml}
\item Solid selection of good classification and regression learners: \CRANpkg{mlr3learners}
\item Even more learners: \url{https://github.com/mlr-org/mlr3extralearners}
\item Tuning of hyperparameters: \CRANpkg{mlr3tuning}
\item Hyperband tuner: \CRANpkg{mlr3hyperband}
\item Visualizations for many \pkg{mlr3} objects: \CRANpkg{mlr3viz}
\item Survival analysis and probabilistic regression: \CRANpkg{mlr3proba}
\item Cluster analysis: \CRANpkg{mlr3cluster}
\item Feature selection filters: \CRANpkg{mlr3filters}
\item Feature selection wrappers: \CRANpkg{mlr3fselect}
\item Interface to real (out-of-memory) data bases: \CRANpkg{mlr3db}
\item Performance measures as plain functions: \CRANpkg{mlr3measures}
}
}

\section{Suggested packages}{

\itemize{
\item Parallelization framework: \CRANpkg{future}
\item Progress bars: \CRANpkg{progressr}
\item Encapsulated evaluation: \CRANpkg{evaluate}, \CRANpkg{callr} (external process)
}
}

\section{Package Options}{

\itemize{
\item \code{"mlr3.debug"}: If set to \code{TRUE}, parallelization via \CRANpkg{future} is
disabled to simplify debugging and provide more concise tracebacks. Note that
results computed with debug mode enabled use a different seeding mechanism
and are not reproducible.
\item \code{"mlr3.allow_utf8_names"}: If set to \code{TRUE}, checks on the feature names
are relaxed, allowing non-ascii characters in column names. This is an
experimental and temporal option to pave the way for text analysis, and will
likely be removed in a future version of the package. analysis.
}
}

\references{
Becker M, Schratz P (2024).
\emph{mlr3spatial: Support for Spatial Objects Within the 'mlr3' Ecosystem}.
R package version 0.6.0, \url{https://mlr3spatial.mlr-org.com}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://mlr3spatial.mlr-org.com}
  \item \url{https://github.com/mlr-org/mlr3spatial}
  \item Report bugs at \url{https://github.com/mlr-org/mlr3spatial/issues}
}

}
\author{
\strong{Maintainer}: Marc Becker \email{marcbecker@posteo.de} (\href{https://orcid.org/0000-0002-8115-0400}{ORCID})

Authors:
\itemize{
  \item Patrick Schratz \email{patrick.schratz@gmail.com} (\href{https://orcid.org/0000-0003-0748-6624}{ORCID})
}

}
